<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XFeatureControlConfig StructType
 * @subpackage Structs
 */
class XFeatureControlConfig extends AbstractStructBase
{
    /**
     * The featureName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $featureName;
    /**
     * The overrideDefault
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideDefault;
    /**
     * The enableSetting
     * Meta information extracted from the WSDL
     * - documentation: This tag will be taken to consideration only when 'overrideDefault' tag is set to True.This will be handled in the code.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableSetting;
    /**
     * Constructor method for XFeatureControlConfig
     * @uses XFeatureControlConfig::setFeatureName()
     * @uses XFeatureControlConfig::setOverrideDefault()
     * @uses XFeatureControlConfig::setEnableSetting()
     * @param string $featureName
     * @param string $overrideDefault
     * @param string $enableSetting
     */
    public function __construct($featureName = null, $overrideDefault = null, $enableSetting = null)
    {
        $this
            ->setFeatureName($featureName)
            ->setOverrideDefault($overrideDefault)
            ->setEnableSetting($enableSetting);
    }
    /**
     * Get featureName value
     * @return string
     */
    public function getFeatureName()
    {
        return $this->featureName;
    }
    /**
     * Set featureName value
     * @param string $featureName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureControlConfig
     */
    public function setFeatureName($featureName = null)
    {
        // validation for constraint: string
        if (!is_null($featureName) && !is_string($featureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($featureName, true), gettype($featureName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($featureName) && mb_strlen($featureName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($featureName)), __LINE__);
        }
        $this->featureName = $featureName;
        return $this;
    }
    /**
     * Get overrideDefault value
     * @return string|null
     */
    public function getOverrideDefault()
    {
        return $this->overrideDefault;
    }
    /**
     * Set overrideDefault value
     * @param string $overrideDefault
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureControlConfig
     */
    public function setOverrideDefault($overrideDefault = null)
    {
        // validation for constraint: string
        if (!is_null($overrideDefault) && !is_string($overrideDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideDefault, true), gettype($overrideDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($overrideDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $overrideDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($overrideDefault, true)), __LINE__);
        }
        $this->overrideDefault = $overrideDefault;
        return $this;
    }
    /**
     * Get enableSetting value
     * @return string|null
     */
    public function getEnableSetting()
    {
        return $this->enableSetting;
    }
    /**
     * Set enableSetting value
     * @param string $enableSetting
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFeatureControlConfig
     */
    public function setEnableSetting($enableSetting = null)
    {
        // validation for constraint: string
        if (!is_null($enableSetting) && !is_string($enableSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableSetting, true), gettype($enableSetting)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableSetting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableSetting, true)), __LINE__);
        }
        $this->enableSetting = $enableSetting;
        return $this;
    }
}
