<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCumaServerSecurityProfile StructType
 * @subpackage Structs
 */
class XCumaServerSecurityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The securityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $securityMode;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The serverIpHostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serverIpHostName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The x509SubjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $x509SubjectName;
    /**
     * Constructor method for XCumaServerSecurityProfile
     * @uses XCumaServerSecurityProfile::setName()
     * @uses XCumaServerSecurityProfile::setSecurityMode()
     * @uses XCumaServerSecurityProfile::setTransportType()
     * @uses XCumaServerSecurityProfile::setServerIpHostName()
     * @uses XCumaServerSecurityProfile::setDescription()
     * @uses XCumaServerSecurityProfile::setX509SubjectName()
     * @param string $name
     * @param string $securityMode
     * @param string $transportType
     * @param string $serverIpHostName
     * @param string $description
     * @param string $x509SubjectName
     */
    public function __construct($name = null, $securityMode = null, $transportType = 'TCP+UDP', $serverIpHostName = null, $description = null, $x509SubjectName = null)
    {
        $this
            ->setName($name)
            ->setSecurityMode($securityMode)
            ->setTransportType($transportType)
            ->setServerIpHostName($serverIpHostName)
            ->setDescription($description)
            ->setX509SubjectName($x509SubjectName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCumaServerSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get securityMode value
     * @return string
     */
    public function getSecurityMode()
    {
        return $this->securityMode;
    }
    /**
     * Set securityMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCumaServerSecurityProfile
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode', is_array($securityMode) ? implode(', ', $securityMode) : var_export($securityMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        $this->securityMode = $securityMode;
        return $this;
    }
    /**
     * Get transportType value
     * @return string
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCumaServerSecurityProfile
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTransport', is_array($transportType) ? implode(', ', $transportType) : var_export($transportType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get serverIpHostName value
     * @return string
     */
    public function getServerIpHostName()
    {
        return $this->serverIpHostName;
    }
    /**
     * Set serverIpHostName value
     * @param string $serverIpHostName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCumaServerSecurityProfile
     */
    public function setServerIpHostName($serverIpHostName = null)
    {
        // validation for constraint: string
        if (!is_null($serverIpHostName) && !is_string($serverIpHostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverIpHostName, true), gettype($serverIpHostName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($serverIpHostName) && mb_strlen($serverIpHostName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($serverIpHostName)), __LINE__);
        }
        $this->serverIpHostName = $serverIpHostName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCumaServerSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCumaServerSecurityProfile
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509SubjectName, true), gettype($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
}
