<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCss StructType
 * @subpackage Structs
 */
class XCss extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - default: General
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $partitionUsage;
    /**
     * Constructor method for XCss
     * @uses XCss::setName()
     * @uses XCss::setDescription()
     * @uses XCss::setMembers()
     * @uses XCss::setPartitionUsage()
     * @param string $name
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param string $partitionUsage
     */
    public function __construct($name = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, $partitionUsage = 'General')
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setMembers($members)
            ->setPartitionUsage($partitionUsage);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCss
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCss
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCss
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCss
     */
    public function setPartitionUsage($partitionUsage = 'General')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage', is_array($partitionUsage) ? implode(', ', $partitionUsage) : var_export($partitionUsage, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
}
