<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCredentialPolicy StructType
 * @subpackage Structs
 */
class XCredentialPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The failedLogon
     * Meta information extracted from the WSDL
     * - documentation: Failed logon must be a number in the range 0 to 100. If 0 is entered, NoLimitForFailedLogon is true
     * - default: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $failedLogon;
    /**
     * The resetFailedLogonAttempts
     * Meta information extracted from the WSDL
     * - documentation: Reset Failed logon attempts must be a number in the range 1 to 120. (minutes)
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $resetFailedLogonAttempts;
    /**
     * The lockoutDuration
     * Meta information extracted from the WSDL
     * - documentation: Lockout duration must be a number in the range 0 to 1440. (minutes), If 0 is entered then Administrator Must Unlock is true.
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $lockoutDuration;
    /**
     * The credChangeDuration
     * Meta information extracted from the WSDL
     * - documentation: Credential change duration must be a number in the range 0 to 129600. (minutes)
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credChangeDuration;
    /**
     * The credExpiresAfter
     * Meta information extracted from the WSDL
     * - documentation: Credential expires after must be a number in the range 0 to 365. (Days). If 0 is entered, then neverExpires is true
     * - default: 180
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credExpiresAfter;
    /**
     * The minCredLength
     * Meta information extracted from the WSDL
     * - documentation: Minimum credential length must be a number in the range 0 to 64.
     * - default: 8
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $minCredLength;
    /**
     * The prevCredStoredNum
     * Meta information extracted from the WSDL
     * - documentation: Stored number of previous credentials must be a number in the range 0 to 25.
     * - default: 12
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $prevCredStoredNum;
    /**
     * The inactiveDaysAllowed
     * Meta information extracted from the WSDL
     * - documentation: Inactive days allowed must be a number in the range 0 to 5000.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $inactiveDaysAllowed;
    /**
     * The expiryWarningDays
     * Meta information extracted from the WSDL
     * - documentation: Expiry warning days must be a number in the range 0 to 90.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $expiryWarningDays;
    /**
     * The trivialCredCheck
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trivialCredCheck;
    /**
     * Constructor method for XCredentialPolicy
     * @uses XCredentialPolicy::setName()
     * @uses XCredentialPolicy::setFailedLogon()
     * @uses XCredentialPolicy::setResetFailedLogonAttempts()
     * @uses XCredentialPolicy::setLockoutDuration()
     * @uses XCredentialPolicy::setCredChangeDuration()
     * @uses XCredentialPolicy::setCredExpiresAfter()
     * @uses XCredentialPolicy::setMinCredLength()
     * @uses XCredentialPolicy::setPrevCredStoredNum()
     * @uses XCredentialPolicy::setInactiveDaysAllowed()
     * @uses XCredentialPolicy::setExpiryWarningDays()
     * @uses XCredentialPolicy::setTrivialCredCheck()
     * @param string $name
     * @param string $failedLogon
     * @param string $resetFailedLogonAttempts
     * @param string $lockoutDuration
     * @param string $credChangeDuration
     * @param string $credExpiresAfter
     * @param string $minCredLength
     * @param string $prevCredStoredNum
     * @param string $inactiveDaysAllowed
     * @param string $expiryWarningDays
     * @param string $trivialCredCheck
     */
    public function __construct($name = null, $failedLogon = '3', $resetFailedLogonAttempts = '30', $lockoutDuration = '30', $credChangeDuration = '0', $credExpiresAfter = '180', $minCredLength = '8', $prevCredStoredNum = '12', $inactiveDaysAllowed = '0', $expiryWarningDays = '0', $trivialCredCheck = 'true')
    {
        $this
            ->setName($name)
            ->setFailedLogon($failedLogon)
            ->setResetFailedLogonAttempts($resetFailedLogonAttempts)
            ->setLockoutDuration($lockoutDuration)
            ->setCredChangeDuration($credChangeDuration)
            ->setCredExpiresAfter($credExpiresAfter)
            ->setMinCredLength($minCredLength)
            ->setPrevCredStoredNum($prevCredStoredNum)
            ->setInactiveDaysAllowed($inactiveDaysAllowed)
            ->setExpiryWarningDays($expiryWarningDays)
            ->setTrivialCredCheck($trivialCredCheck);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get failedLogon value
     * @return string
     */
    public function getFailedLogon()
    {
        return $this->failedLogon;
    }
    /**
     * Set failedLogon value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failedLogon
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setFailedLogon($failedLogon = '3')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($failedLogon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($failedLogon) ? implode(', ', $failedLogon) : var_export($failedLogon, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->failedLogon = $failedLogon;
        return $this;
    }
    /**
     * Get resetFailedLogonAttempts value
     * @return string
     */
    public function getResetFailedLogonAttempts()
    {
        return $this->resetFailedLogonAttempts;
    }
    /**
     * Set resetFailedLogonAttempts value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resetFailedLogonAttempts
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setResetFailedLogonAttempts($resetFailedLogonAttempts = '30')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($resetFailedLogonAttempts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($resetFailedLogonAttempts) ? implode(', ', $resetFailedLogonAttempts) : var_export($resetFailedLogonAttempts, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->resetFailedLogonAttempts = $resetFailedLogonAttempts;
        return $this;
    }
    /**
     * Get lockoutDuration value
     * @return string
     */
    public function getLockoutDuration()
    {
        return $this->lockoutDuration;
    }
    /**
     * Set lockoutDuration value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lockoutDuration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setLockoutDuration($lockoutDuration = '30')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($lockoutDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($lockoutDuration) ? implode(', ', $lockoutDuration) : var_export($lockoutDuration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->lockoutDuration = $lockoutDuration;
        return $this;
    }
    /**
     * Get credChangeDuration value
     * @return string
     */
    public function getCredChangeDuration()
    {
        return $this->credChangeDuration;
    }
    /**
     * Set credChangeDuration value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credChangeDuration
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setCredChangeDuration($credChangeDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($credChangeDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($credChangeDuration) ? implode(', ', $credChangeDuration) : var_export($credChangeDuration, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->credChangeDuration = $credChangeDuration;
        return $this;
    }
    /**
     * Get credExpiresAfter value
     * @return string
     */
    public function getCredExpiresAfter()
    {
        return $this->credExpiresAfter;
    }
    /**
     * Set credExpiresAfter value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credExpiresAfter
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setCredExpiresAfter($credExpiresAfter = '180')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($credExpiresAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($credExpiresAfter) ? implode(', ', $credExpiresAfter) : var_export($credExpiresAfter, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->credExpiresAfter = $credExpiresAfter;
        return $this;
    }
    /**
     * Get minCredLength value
     * @return string
     */
    public function getMinCredLength()
    {
        return $this->minCredLength;
    }
    /**
     * Set minCredLength value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $minCredLength
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setMinCredLength($minCredLength = '8')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($minCredLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($minCredLength) ? implode(', ', $minCredLength) : var_export($minCredLength, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->minCredLength = $minCredLength;
        return $this;
    }
    /**
     * Get prevCredStoredNum value
     * @return string
     */
    public function getPrevCredStoredNum()
    {
        return $this->prevCredStoredNum;
    }
    /**
     * Set prevCredStoredNum value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prevCredStoredNum
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setPrevCredStoredNum($prevCredStoredNum = '12')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($prevCredStoredNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($prevCredStoredNum) ? implode(', ', $prevCredStoredNum) : var_export($prevCredStoredNum, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->prevCredStoredNum = $prevCredStoredNum;
        return $this;
    }
    /**
     * Get inactiveDaysAllowed value
     * @return string
     */
    public function getInactiveDaysAllowed()
    {
        return $this->inactiveDaysAllowed;
    }
    /**
     * Set inactiveDaysAllowed value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inactiveDaysAllowed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setInactiveDaysAllowed($inactiveDaysAllowed = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($inactiveDaysAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($inactiveDaysAllowed) ? implode(', ', $inactiveDaysAllowed) : var_export($inactiveDaysAllowed, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->inactiveDaysAllowed = $inactiveDaysAllowed;
        return $this;
    }
    /**
     * Get expiryWarningDays value
     * @return string
     */
    public function getExpiryWarningDays()
    {
        return $this->expiryWarningDays;
    }
    /**
     * Set expiryWarningDays value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expiryWarningDays
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setExpiryWarningDays($expiryWarningDays = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($expiryWarningDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($expiryWarningDays) ? implode(', ', $expiryWarningDays) : var_export($expiryWarningDays, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->expiryWarningDays = $expiryWarningDays;
        return $this;
    }
    /**
     * Get trivialCredCheck value
     * @return string
     */
    public function getTrivialCredCheck()
    {
        return $this->trivialCredCheck;
    }
    /**
     * Set trivialCredCheck value
     * @param string $trivialCredCheck
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setTrivialCredCheck($trivialCredCheck = 'true')
    {
        // validation for constraint: string
        if (!is_null($trivialCredCheck) && !is_string($trivialCredCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trivialCredCheck, true), gettype($trivialCredCheck)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($trivialCredCheck) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $trivialCredCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($trivialCredCheck, true)), __LINE__);
        }
        $this->trivialCredCheck = $trivialCredCheck;
        return $this;
    }
}
