<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XConferenceBridge StructType
 * @subpackage Structs
 */
class XConferenceBridge extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:Name
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - default: Hub_None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The subUnit
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values range from 1 to 4.The value should be given as per the formula. Cisco Media Server : subunit = ((Extract two digits after 'A'
     * from the name)-2)/3 + 1. Cisco Conference Bridge: subunit = ((Extract two digits after 'C' from the name)-1)/3 + 1
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subUnit;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Conference Bridge Hardware.For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the
     * product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Video Conference Bridge(IPVC-35xx),Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The maximumCapacity
     * Meta information extracted from the WSDL
     * - documentation: This tag is mandatory for Cisco Conference Bridge(WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco IOS Enhanced Conference Bridge
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The destinationAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $destinationAddress;
    /**
     * The mcuConferenceBridgeSipPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mcuConferenceBridgeSipPort;
    /**
     * The sipProfile
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipProfile;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The normalizationScript
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $normalizationScript;
    /**
     * The enableTrace
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTrace;
    /**
     * The normalizationScriptInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos
     */
    public $normalizationScriptInfos;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The httpPort
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - default: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $httpPort;
    /**
     * The useHttps
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHttps;
    /**
     * The addresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Addresses
     */
    public $addresses;
    /**
     * The conferenceBridgePrefix
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $conferenceBridgePrefix;
    /**
     * The overrideSIPTrunkAddress
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideSIPTrunkAddress;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * Constructor method for XConferenceBridge
     * @uses XConferenceBridge::setName()
     * @uses XConferenceBridge::setProduct()
     * @uses XConferenceBridge::setDevicePoolName()
     * @uses XConferenceBridge::setLocationName()
     * @uses XConferenceBridge::setDescription()
     * @uses XConferenceBridge::setCommonDeviceConfigName()
     * @uses XConferenceBridge::setSubUnit()
     * @uses XConferenceBridge::setLoadInformation()
     * @uses XConferenceBridge::setVendorConfig()
     * @uses XConferenceBridge::setMaximumCapacity()
     * @uses XConferenceBridge::setUseTrustedRelayPoint()
     * @uses XConferenceBridge::setSecurityProfileName()
     * @uses XConferenceBridge::setDestinationAddress()
     * @uses XConferenceBridge::setMcuConferenceBridgeSipPort()
     * @uses XConferenceBridge::setSipProfile()
     * @uses XConferenceBridge::setSrtpAllowed()
     * @uses XConferenceBridge::setNormalizationScript()
     * @uses XConferenceBridge::setEnableTrace()
     * @uses XConferenceBridge::setNormalizationScriptInfos()
     * @uses XConferenceBridge::setUserName()
     * @uses XConferenceBridge::setPassword()
     * @uses XConferenceBridge::setHttpPort()
     * @uses XConferenceBridge::setUseHttps()
     * @uses XConferenceBridge::setAddresses()
     * @uses XConferenceBridge::setConferenceBridgePrefix()
     * @uses XConferenceBridge::setOverrideSIPTrunkAddress()
     * @uses XConferenceBridge::setSipTrunkName()
     * @param string $name
     * @param string $product
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $subUnit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param string $destinationAddress
     * @param string $mcuConferenceBridgeSipPort
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile
     * @param string $srtpAllowed
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript
     * @param string $enableTrace
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos
     * @param string $userName
     * @param string $password
     * @param string $httpPort
     * @param string $useHttps
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses
     * @param string $conferenceBridgePrefix
     * @param string $overrideSIPTrunkAddress
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     */
    public function __construct($name = null, $product = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = 'Hub_None', $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $subUnit = '0', \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $maximumCapacity = null, $useTrustedRelayPoint = 'Default', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, $destinationAddress = null, $mcuConferenceBridgeSipPort = '5060', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile = null, $srtpAllowed = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript = null, $enableTrace = null, \Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos = null, $userName = null, $password = null, $httpPort = '80', $useHttps = 'false', \Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses = null, $conferenceBridgePrefix = null, $overrideSIPTrunkAddress = 'false', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setDescription($description)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setSubUnit($subUnit)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setDestinationAddress($destinationAddress)
            ->setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort)
            ->setSipProfile($sipProfile)
            ->setSrtpAllowed($srtpAllowed)
            ->setNormalizationScript($normalizationScript)
            ->setEnableTrace($enableTrace)
            ->setNormalizationScriptInfos($normalizationScriptInfos)
            ->setUserName($userName)
            ->setPassword($password)
            ->setHttpPort($httpPort)
            ->setUseHttps($useHttps)
            ->setAddresses($addresses)
            ->setConferenceBridgePrefix($conferenceBridgePrefix)
            ->setOverrideSIPTrunkAddress($overrideSIPTrunkAddress)
            ->setSipTrunkName($sipTrunkName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setDevicePoolName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setLocationName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = 'Hub_None')
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setCommonDeviceConfigName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subUnit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSubUnit($subUnit = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($subUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($subUnit) ? implode(', ', $subUnit) : var_export($subUnit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setLoadInformation(\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setVendorConfig(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maximumCapacity
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maximumCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maximumCapacity) ? implode(', ', $maximumCapacity) : var_export($maximumCapacity, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSecurityProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAddress, true), gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get mcuConferenceBridgeSipPort value
     * @return string|null
     */
    public function getMcuConferenceBridgeSipPort()
    {
        return $this->mcuConferenceBridgeSipPort;
    }
    /**
     * Set mcuConferenceBridgeSipPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mcuConferenceBridgeSipPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort = '5060')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($mcuConferenceBridgeSipPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($mcuConferenceBridgeSipPort) ? implode(', ', $mcuConferenceBridgeSipPort) : var_export($mcuConferenceBridgeSipPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mcuConferenceBridgeSipPort = $mcuConferenceBridgeSipPort;
        return $this;
    }
    /**
     * Get sipProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipProfile()
    {
        return isset($this->sipProfile) ? $this->sipProfile : null;
    }
    /**
     * Set sipProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSipProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfile = null)
    {
        if (is_null($sipProfile) || (is_array($sipProfile) && empty($sipProfile))) {
            unset($this->sipProfile);
        } else {
            $this->sipProfile = $sipProfile;
        }
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srtpAllowed, true), gettype($srtpAllowed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($srtpAllowed, true)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get normalizationScript value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNormalizationScript()
    {
        return isset($this->normalizationScript) ? $this->normalizationScript : null;
    }
    /**
     * Set normalizationScript value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setNormalizationScript(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $normalizationScript = null)
    {
        if (is_null($normalizationScript) || (is_array($normalizationScript) && empty($normalizationScript))) {
            unset($this->normalizationScript);
        } else {
            $this->normalizationScript = $normalizationScript;
        }
        return $this;
    }
    /**
     * Get enableTrace value
     * @return string|null
     */
    public function getEnableTrace()
    {
        return $this->enableTrace;
    }
    /**
     * Set enableTrace value
     * @param string $enableTrace
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setEnableTrace($enableTrace = null)
    {
        // validation for constraint: string
        if (!is_null($enableTrace) && !is_string($enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableTrace, true), gettype($enableTrace)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableTrace) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableTrace, true)), __LINE__);
        }
        $this->enableTrace = $enableTrace;
        return $this;
    }
    /**
     * Get normalizationScriptInfos value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos|null
     */
    public function getNormalizationScriptInfos()
    {
        return $this->normalizationScriptInfos;
    }
    /**
     * Set normalizationScriptInfos value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setNormalizationScriptInfos(\Losc\CucmBundle\Model\Webservice\StructType\NormalizationScriptInfos $normalizationScriptInfos = null)
    {
        $this->normalizationScriptInfos = $normalizationScriptInfos;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get httpPort value
     * @return string|null
     */
    public function getHttpPort()
    {
        return $this->httpPort;
    }
    /**
     * Set httpPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $httpPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setHttpPort($httpPort = '80')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($httpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($httpPort) ? implode(', ', $httpPort) : var_export($httpPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->httpPort = $httpPort;
        return $this;
    }
    /**
     * Get useHttps value
     * @return string|null
     */
    public function getUseHttps()
    {
        return $this->useHttps;
    }
    /**
     * Set useHttps value
     * @param string $useHttps
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setUseHttps($useHttps = 'false')
    {
        // validation for constraint: string
        if (!is_null($useHttps) && !is_string($useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useHttps, true), gettype($useHttps)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useHttps) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useHttps, true)), __LINE__);
        }
        $this->useHttps = $useHttps;
        return $this;
    }
    /**
     * Get addresses value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Addresses|null
     */
    public function getAddresses()
    {
        return $this->addresses;
    }
    /**
     * Set addresses value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setAddresses(\Losc\CucmBundle\Model\Webservice\StructType\Addresses $addresses = null)
    {
        $this->addresses = $addresses;
        return $this;
    }
    /**
     * Get conferenceBridgePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConferenceBridgePrefix()
    {
        return isset($this->conferenceBridgePrefix) ? $this->conferenceBridgePrefix : null;
    }
    /**
     * Set conferenceBridgePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conferenceBridgePrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setConferenceBridgePrefix($conferenceBridgePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceBridgePrefix) && !is_string($conferenceBridgePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conferenceBridgePrefix, true), gettype($conferenceBridgePrefix)), __LINE__);
        }
        if (is_null($conferenceBridgePrefix) || (is_array($conferenceBridgePrefix) && empty($conferenceBridgePrefix))) {
            unset($this->conferenceBridgePrefix);
        } else {
            $this->conferenceBridgePrefix = $conferenceBridgePrefix;
        }
        return $this;
    }
    /**
     * Get overrideSIPTrunkAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverrideSIPTrunkAddress()
    {
        return isset($this->overrideSIPTrunkAddress) ? $this->overrideSIPTrunkAddress : null;
    }
    /**
     * Set overrideSIPTrunkAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overrideSIPTrunkAddress
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setOverrideSIPTrunkAddress($overrideSIPTrunkAddress = 'false')
    {
        // validation for constraint: string
        if (!is_null($overrideSIPTrunkAddress) && !is_string($overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideSIPTrunkAddress, true), gettype($overrideSIPTrunkAddress)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($overrideSIPTrunkAddress) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($overrideSIPTrunkAddress, true)), __LINE__);
        }
        if (is_null($overrideSIPTrunkAddress) || (is_array($overrideSIPTrunkAddress) && empty($overrideSIPTrunkAddress))) {
            unset($this->overrideSIPTrunkAddress);
        } else {
            $this->overrideSIPTrunkAddress = $overrideSIPTrunkAddress;
        }
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XConferenceBridge
     */
    public function setSipTrunkName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
}
