<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCcdHostedDNGroup StructType
 * @subpackage Structs
 */
class XCcdHostedDNGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The pstnFailoverStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * Constructor method for XCcdHostedDNGroup
     * @uses XCcdHostedDNGroup::setName()
     * @uses XCcdHostedDNGroup::setDescription()
     * @uses XCcdHostedDNGroup::setPstnFailoverStripDigits()
     * @uses XCcdHostedDNGroup::setPstnFailoverPrependDigits()
     * @uses XCcdHostedDNGroup::setUsePstnFailover()
     * @param string $name
     * @param string $description
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     */
    public function __construct($name = null, $description = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = 'false')
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return isset($this->pstnFailoverStripDigits) ? $this->pstnFailoverStripDigits : null;
    }
    /**
     * Set pstnFailoverStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailoverStripDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($pstnFailoverStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($pstnFailoverStripDigits) ? implode(', ', $pstnFailoverStripDigits) : var_export($pstnFailoverStripDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($pstnFailoverStripDigits) || (is_array($pstnFailoverStripDigits) && empty($pstnFailoverStripDigits))) {
            unset($this->pstnFailoverStripDigits);
        } else {
            $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        }
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailoverPrependDigits) && !is_string($pstnFailoverPrependDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailoverPrependDigits, true), gettype($pstnFailoverPrependDigits)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($pstnFailoverPrependDigits) && mb_strlen($pstnFailoverPrependDigits) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($pstnFailoverPrependDigits)), __LINE__);
        }
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setUsePstnFailover($usePstnFailover = 'false')
    {
        // validation for constraint: string
        if (!is_null($usePstnFailover) && !is_string($usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usePstnFailover, true), gettype($usePstnFailover)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($usePstnFailover) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePstnFailover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($usePstnFailover, true)), __LINE__);
        }
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
}
