<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCcdAdvertisingService StructType
 * @subpackage Structs
 */
class XCcdAdvertisingService extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The hostDnGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $hostDnGroup;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The safSipTrunk
     * Meta information extracted from the WSDL
     * - documentation: Either safSipTrunk, safH323Trunk or both should be configured while adding
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $safSipTrunk;
    /**
     * The safH323Trunk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $safH323Trunk;
    /**
     * Constructor method for XCcdAdvertisingService
     * @uses XCcdAdvertisingService::setName()
     * @uses XCcdAdvertisingService::setHostDnGroup()
     * @uses XCcdAdvertisingService::setDescription()
     * @uses XCcdAdvertisingService::setIsActivated()
     * @uses XCcdAdvertisingService::setSafSipTrunk()
     * @uses XCcdAdvertisingService::setSafH323Trunk()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $hostDnGroup
     * @param string $description
     * @param string $isActivated
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSipTrunk
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safH323Trunk
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $hostDnGroup = null, $description = null, $isActivated = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSipTrunk = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safH323Trunk = null)
    {
        $this
            ->setName($name)
            ->setHostDnGroup($hostDnGroup)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setSafSipTrunk($safSipTrunk)
            ->setSafH323Trunk($safH323Trunk);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdAdvertisingService
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get hostDnGroup value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getHostDnGroup()
    {
        return $this->hostDnGroup;
    }
    /**
     * Set hostDnGroup value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $hostDnGroup
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdAdvertisingService
     */
    public function setHostDnGroup(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $hostDnGroup = null)
    {
        $this->hostDnGroup = $hostDnGroup;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdAdvertisingService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdAdvertisingService
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get safSipTrunk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSafSipTrunk()
    {
        return isset($this->safSipTrunk) ? $this->safSipTrunk : null;
    }
    /**
     * Set safSipTrunk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSipTrunk
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdAdvertisingService
     */
    public function setSafSipTrunk(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSipTrunk = null)
    {
        if (is_null($safSipTrunk) || (is_array($safSipTrunk) && empty($safSipTrunk))) {
            unset($this->safSipTrunk);
        } else {
            $this->safSipTrunk = $safSipTrunk;
        }
        return $this;
    }
    /**
     * Get safH323Trunk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSafH323Trunk()
    {
        return isset($this->safH323Trunk) ? $this->safH323Trunk : null;
    }
    /**
     * Set safH323Trunk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $safH323Trunk
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCcdAdvertisingService
     */
    public function setSafH323Trunk(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safH323Trunk = null)
    {
        if (is_null($safH323Trunk) || (is_array($safH323Trunk) && empty($safH323Trunk))) {
            unset($this->safH323Trunk);
        } else {
            $this->safH323Trunk = $safH323Trunk;
        }
        return $this;
    }
}
