<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallerFilterListMember StructType
 * @subpackage Structs
 */
class XCallerFilterListMember extends AbstractStructBase
{
    /**
     * The DnMask
     * Meta information extracted from the WSDL
     * - documentation: Mandatory when "callerFilterMask" has value as Directory Number
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DnMask;
    /**
     * The callerFilterMask
     * Meta information extracted from the WSDL
     * - documentation: Mandatory when value is a directory number
     * - default: Directory Number
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callerFilterMask;
    /**
     * Constructor method for XCallerFilterListMember
     * @uses XCallerFilterListMember::setDnMask()
     * @uses XCallerFilterListMember::setCallerFilterMask()
     * @param string $dnMask
     * @param string $callerFilterMask
     */
    public function __construct($dnMask = null, $callerFilterMask = 'Directory Number')
    {
        $this
            ->setDnMask($dnMask)
            ->setCallerFilterMask($callerFilterMask);
    }
    /**
     * Get DnMask value
     * @return string
     */
    public function getDnMask()
    {
        return $this->DnMask;
    }
    /**
     * Set DnMask value
     * @param string $dnMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallerFilterListMember
     */
    public function setDnMask($dnMask = null)
    {
        // validation for constraint: string
        if (!is_null($dnMask) && !is_string($dnMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnMask, true), gettype($dnMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($dnMask) && mb_strlen($dnMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($dnMask)), __LINE__);
        }
        $this->DnMask = $dnMask;
        return $this;
    }
    /**
     * Get callerFilterMask value
     * @return string
     */
    public function getCallerFilterMask()
    {
        return $this->callerFilterMask;
    }
    /**
     * Set callerFilterMask value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerFilterMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallerFilterListMember
     */
    public function setCallerFilterMask($callerFilterMask = 'Directory Number')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::valueIsValid($callerFilterMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask', is_array($callerFilterMask) ? implode(', ', $callerFilterMask) : var_export($callerFilterMask, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::getValidValues())), __LINE__);
        }
        $this->callerFilterMask = $callerFilterMask;
        return $this;
    }
}
