<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallManagerGroup StructType
 * @subpackage Structs
 */
class XCallManagerGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The tftpDefault
     * Meta information extracted from the WSDL
     * - documentation: Only use when setting TFTP Default to true. Setting to true will result in setting all other CallManager groups to false.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpDefault;
    /**
     * Constructor method for XCallManagerGroup
     * @uses XCallManagerGroup::setName()
     * @uses XCallManagerGroup::setMembers()
     * @uses XCallManagerGroup::setTftpDefault()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param string $tftpDefault
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, $tftpDefault = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setTftpDefault($tftpDefault);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallManagerGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallManagerGroup
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get tftpDefault value
     * @return string|null
     */
    public function getTftpDefault()
    {
        return $this->tftpDefault;
    }
    /**
     * Set tftpDefault value
     * @param string $tftpDefault
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XCallManagerGroup
     */
    public function setTftpDefault($tftpDefault = null)
    {
        // validation for constraint: string
        if (!is_null($tftpDefault) && !is_string($tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tftpDefault, true), gettype($tftpDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($tftpDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($tftpDefault, true)), __LINE__);
        }
        $this->tftpDefault = $tftpDefault;
        return $this;
    }
}
