<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XApplicationUserCapfProfile StructType
 * @subpackage Structs
 */
class XApplicationUserCapfProfile extends AbstractStructBase
{
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $applicationUser;
    /**
     * The instanceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $instanceId;
    /**
     * The certificateOperation
     * Meta information extracted from the WSDL
     * - default: No Pending Operation
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The authenticationString
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The operationCompletion
     * Meta information extracted from the WSDL
     * - documentation: Required format is YYYY:MM:DD:HH:SS. Read Only when certificateOperation is 'No Pending Operation'. Please provide the above format while adding a new device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $operationCompletion;
    /**
     * Constructor method for XApplicationUserCapfProfile
     * @uses XApplicationUserCapfProfile::setApplicationUser()
     * @uses XApplicationUserCapfProfile::setInstanceId()
     * @uses XApplicationUserCapfProfile::setCertificateOperation()
     * @uses XApplicationUserCapfProfile::setAuthenticationMode()
     * @uses XApplicationUserCapfProfile::setKeySize()
     * @uses XApplicationUserCapfProfile::setAuthenticationString()
     * @uses XApplicationUserCapfProfile::setOperationCompletion()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @param string $instanceId
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $authenticationString
     * @param string $operationCompletion
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null, $instanceId = null, $certificateOperation = 'No Pending Operation', $authenticationMode = 'By Null String', $keySize = '1024', $authenticationString = null, $operationCompletion = null)
    {
        $this
            ->setApplicationUser($applicationUser)
            ->setInstanceId($instanceId)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setAuthenticationString($authenticationString)
            ->setOperationCompletion($operationCompletion);
    }
    /**
     * Get applicationUser value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationUserCapfProfile
     */
    public function setApplicationUser(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get instanceId value
     * @return string
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationUserCapfProfile
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceId, true), gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationUserCapfProfile
     */
    public function setCertificateOperation($certificateOperation = 'No Pending Operation')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation', is_array($certificateOperation) ? implode(', ', $certificateOperation) : var_export($certificateOperation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationUserCapfProfile
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode', is_array($authenticationMode) ? implode(', ', $authenticationMode) : var_export($authenticationMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationUserCapfProfile
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize', is_array($keySize) ? implode(', ', $keySize) : var_export($keySize, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationUserCapfProfile
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationString, true), gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XApplicationUserCapfProfile
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationCompletion, true), gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
}
