<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAdvertisedPatterns StructType
 * @subpackage Structs
 */
class XAdvertisedPatterns extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The pstnFailStrip
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pstnFailStrip;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The patternType
     * Meta information extracted from the WSDL
     * - default: Enterprise Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternType;
    /**
     * The hostedRoutePSTNRule
     * Meta information extracted from the WSDL
     * - default: Specify
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostedRoutePSTNRule;
    /**
     * The pstnFailPrepend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailPrepend;
    /**
     * Constructor method for XAdvertisedPatterns
     * @uses XAdvertisedPatterns::setPattern()
     * @uses XAdvertisedPatterns::setPstnFailStrip()
     * @uses XAdvertisedPatterns::setDescription()
     * @uses XAdvertisedPatterns::setPatternType()
     * @uses XAdvertisedPatterns::setHostedRoutePSTNRule()
     * @uses XAdvertisedPatterns::setPstnFailPrepend()
     * @param string $pattern
     * @param string $pstnFailStrip
     * @param string $description
     * @param string $patternType
     * @param string $hostedRoutePSTNRule
     * @param string $pstnFailPrepend
     */
    public function __construct($pattern = null, $pstnFailStrip = '0', $description = null, $patternType = 'Enterprise Number', $hostedRoutePSTNRule = 'Specify', $pstnFailPrepend = null)
    {
        $this
            ->setPattern($pattern)
            ->setPstnFailStrip($pstnFailStrip)
            ->setDescription($description)
            ->setPatternType($patternType)
            ->setHostedRoutePSTNRule($hostedRoutePSTNRule)
            ->setPstnFailPrepend($pstnFailPrepend);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAdvertisedPatterns
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get pstnFailStrip value
     * @return string
     */
    public function getPstnFailStrip()
    {
        return $this->pstnFailStrip;
    }
    /**
     * Set pstnFailStrip value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailStrip
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAdvertisedPatterns
     */
    public function setPstnFailStrip($pstnFailStrip = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($pstnFailStrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($pstnFailStrip) ? implode(', ', $pstnFailStrip) : var_export($pstnFailStrip, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pstnFailStrip = $pstnFailStrip;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAdvertisedPatterns
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get patternType value
     * @return string|null
     */
    public function getPatternType()
    {
        return $this->patternType;
    }
    /**
     * Set patternType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XGlobalNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XGlobalNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAdvertisedPatterns
     */
    public function setPatternType($patternType = 'Enterprise Number')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XGlobalNumber::valueIsValid($patternType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XGlobalNumber', is_array($patternType) ? implode(', ', $patternType) : var_export($patternType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XGlobalNumber::getValidValues())), __LINE__);
        }
        $this->patternType = $patternType;
        return $this;
    }
    /**
     * Get hostedRoutePSTNRule value
     * @return string|null
     */
    public function getHostedRoutePSTNRule()
    {
        return $this->hostedRoutePSTNRule;
    }
    /**
     * Set hostedRoutePSTNRule value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHostedRoutePatternPSTNRule::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHostedRoutePatternPSTNRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hostedRoutePSTNRule
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAdvertisedPatterns
     */
    public function setHostedRoutePSTNRule($hostedRoutePSTNRule = 'Specify')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHostedRoutePatternPSTNRule::valueIsValid($hostedRoutePSTNRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHostedRoutePatternPSTNRule', is_array($hostedRoutePSTNRule) ? implode(', ', $hostedRoutePSTNRule) : var_export($hostedRoutePSTNRule, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHostedRoutePatternPSTNRule::getValidValues())), __LINE__);
        }
        $this->hostedRoutePSTNRule = $hostedRoutePSTNRule;
        return $this;
    }
    /**
     * Get pstnFailPrepend value
     * @return string|null
     */
    public function getPstnFailPrepend()
    {
        return $this->pstnFailPrepend;
    }
    /**
     * Set pstnFailPrepend value
     * @param string $pstnFailPrepend
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XAdvertisedPatterns
     */
    public function setPstnFailPrepend($pstnFailPrepend = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailPrepend) && !is_string($pstnFailPrepend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailPrepend, true), gettype($pstnFailPrepend)), __LINE__);
        }
        $this->pstnFailPrepend = $pstnFailPrepend;
        return $this;
    }
}
