<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSipDialRulesReq StructType
 * @subpackage Structs
 */
class UpdateSipDialRulesReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The removePatterns
     * Meta information extracted from the WSDL
     * - choice: removePatterns | addPatterns | patterns
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemovePatterns
     */
    public $removePatterns;
    /**
     * The addPatterns
     * Meta information extracted from the WSDL
     * - choice: removePatterns | addPatterns | patterns
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddPatterns
     */
    public $addPatterns;
    /**
     * The patterns
     * Meta information extracted from the WSDL
     * - choice: removePatterns | addPatterns | patterns
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Patterns
     */
    public $patterns;
    /**
     * The removePlars
     * Meta information extracted from the WSDL
     * - choice: removePlars | addPlars | plars
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemovePlars
     */
    public $removePlars;
    /**
     * The addPlars
     * Meta information extracted from the WSDL
     * - choice: removePlars | addPlars | plars
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddPlars
     */
    public $addPlars;
    /**
     * The plars
     * Meta information extracted from the WSDL
     * - choice: removePlars | addPlars | plars
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Plars
     */
    public $plars;
    /**
     * Constructor method for UpdateSipDialRulesReq
     * @uses UpdateSipDialRulesReq::setNewName()
     * @uses UpdateSipDialRulesReq::setDescription()
     * @uses UpdateSipDialRulesReq::setRemovePatterns()
     * @uses UpdateSipDialRulesReq::setAddPatterns()
     * @uses UpdateSipDialRulesReq::setPatterns()
     * @uses UpdateSipDialRulesReq::setRemovePlars()
     * @uses UpdateSipDialRulesReq::setAddPlars()
     * @uses UpdateSipDialRulesReq::setPlars()
     * @param string $newName
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemovePatterns $removePatterns
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPatterns $addPatterns
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemovePlars $removePlars
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPlars $addPlars
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars
     */
    public function __construct($newName = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\RemovePatterns $removePatterns = null, \Losc\CucmBundle\Model\Webservice\StructType\AddPatterns $addPatterns = null, \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns = null, \Losc\CucmBundle\Model\Webservice\StructType\RemovePlars $removePlars = null, \Losc\CucmBundle\Model\Webservice\StructType\AddPlars $addPlars = null, \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRemovePatterns($removePatterns)
            ->setAddPatterns($addPatterns)
            ->setPatterns($patterns)
            ->setRemovePlars($removePlars)
            ->setAddPlars($addPlars)
            ->setPlars($plars);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get removePatterns value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemovePatterns|null
     */
    public function getRemovePatterns()
    {
        return isset($this->removePatterns) ? $this->removePatterns : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemovePatterns method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemovePatterns method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemovePatternsForChoiceConstraintsFromSetRemovePatterns($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addPatterns',
            'patterns',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removePatterns can\'t be set as the property %s is already set. Only one property must be set among these properties: removePatterns, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removePatterns value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemovePatterns $removePatterns
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setRemovePatterns(\Losc\CucmBundle\Model\Webservice\StructType\RemovePatterns $removePatterns = null)
    {
        // validation for constraint: choice(removePatterns, addPatterns, patterns)
        if ('' !== ($removePatternsChoiceErrorMessage = self::validateRemovePatternsForChoiceConstraintsFromSetRemovePatterns($removePatterns))) {
            throw new \InvalidArgumentException($removePatternsChoiceErrorMessage, __LINE__);
        }
        if (is_null($removePatterns) || (is_array($removePatterns) && empty($removePatterns))) {
            unset($this->removePatterns);
        } else {
            $this->removePatterns = $removePatterns;
        }
        return $this;
    }
    /**
     * Get addPatterns value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddPatterns|null
     */
    public function getAddPatterns()
    {
        return isset($this->addPatterns) ? $this->addPatterns : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddPatterns method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddPatterns method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddPatternsForChoiceConstraintsFromSetAddPatterns($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removePatterns',
            'patterns',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addPatterns can\'t be set as the property %s is already set. Only one property must be set among these properties: addPatterns, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addPatterns value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPatterns $addPatterns
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setAddPatterns(\Losc\CucmBundle\Model\Webservice\StructType\AddPatterns $addPatterns = null)
    {
        // validation for constraint: choice(removePatterns, addPatterns, patterns)
        if ('' !== ($addPatternsChoiceErrorMessage = self::validateAddPatternsForChoiceConstraintsFromSetAddPatterns($addPatterns))) {
            throw new \InvalidArgumentException($addPatternsChoiceErrorMessage, __LINE__);
        }
        if (is_null($addPatterns) || (is_array($addPatterns) && empty($addPatterns))) {
            unset($this->addPatterns);
        } else {
            $this->addPatterns = $addPatterns;
        }
        return $this;
    }
    /**
     * Get patterns value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Patterns|null
     */
    public function getPatterns()
    {
        return isset($this->patterns) ? $this->patterns : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPatterns method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPatterns method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePatternsForChoiceConstraintsFromSetPatterns($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removePatterns',
            'addPatterns',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property patterns can\'t be set as the property %s is already set. Only one property must be set among these properties: patterns, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set patterns value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setPatterns(\Losc\CucmBundle\Model\Webservice\StructType\Patterns $patterns = null)
    {
        // validation for constraint: choice(removePatterns, addPatterns, patterns)
        if ('' !== ($patternsChoiceErrorMessage = self::validatePatternsForChoiceConstraintsFromSetPatterns($patterns))) {
            throw new \InvalidArgumentException($patternsChoiceErrorMessage, __LINE__);
        }
        if (is_null($patterns) || (is_array($patterns) && empty($patterns))) {
            unset($this->patterns);
        } else {
            $this->patterns = $patterns;
        }
        return $this;
    }
    /**
     * Get removePlars value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemovePlars|null
     */
    public function getRemovePlars()
    {
        return isset($this->removePlars) ? $this->removePlars : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemovePlars method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemovePlars method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemovePlarsForChoiceConstraintsFromSetRemovePlars($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addPlars',
            'plars',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removePlars can\'t be set as the property %s is already set. Only one property must be set among these properties: removePlars, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removePlars value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemovePlars $removePlars
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setRemovePlars(\Losc\CucmBundle\Model\Webservice\StructType\RemovePlars $removePlars = null)
    {
        // validation for constraint: choice(removePlars, addPlars, plars)
        if ('' !== ($removePlarsChoiceErrorMessage = self::validateRemovePlarsForChoiceConstraintsFromSetRemovePlars($removePlars))) {
            throw new \InvalidArgumentException($removePlarsChoiceErrorMessage, __LINE__);
        }
        if (is_null($removePlars) || (is_array($removePlars) && empty($removePlars))) {
            unset($this->removePlars);
        } else {
            $this->removePlars = $removePlars;
        }
        return $this;
    }
    /**
     * Get addPlars value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddPlars|null
     */
    public function getAddPlars()
    {
        return isset($this->addPlars) ? $this->addPlars : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddPlars method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddPlars method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddPlarsForChoiceConstraintsFromSetAddPlars($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removePlars',
            'plars',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addPlars can\'t be set as the property %s is already set. Only one property must be set among these properties: addPlars, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addPlars value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddPlars $addPlars
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setAddPlars(\Losc\CucmBundle\Model\Webservice\StructType\AddPlars $addPlars = null)
    {
        // validation for constraint: choice(removePlars, addPlars, plars)
        if ('' !== ($addPlarsChoiceErrorMessage = self::validateAddPlarsForChoiceConstraintsFromSetAddPlars($addPlars))) {
            throw new \InvalidArgumentException($addPlarsChoiceErrorMessage, __LINE__);
        }
        if (is_null($addPlars) || (is_array($addPlars) && empty($addPlars))) {
            unset($this->addPlars);
        } else {
            $this->addPlars = $addPlars;
        }
        return $this;
    }
    /**
     * Get plars value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Plars|null
     */
    public function getPlars()
    {
        return isset($this->plars) ? $this->plars : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPlars method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlars method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePlarsForChoiceConstraintsFromSetPlars($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removePlars',
            'addPlars',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property plars can\'t be set as the property %s is already set. Only one property must be set among these properties: plars, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set plars value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Plars $plars
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateSipDialRulesReq
     */
    public function setPlars(\Losc\CucmBundle\Model\Webservice\StructType\Plars $plars = null)
    {
        // validation for constraint: choice(removePlars, addPlars, plars)
        if ('' !== ($plarsChoiceErrorMessage = self::validatePlarsForChoiceConstraintsFromSetPlars($plars))) {
            throw new \InvalidArgumentException($plarsChoiceErrorMessage, __LINE__);
        }
        if (is_null($plars) || (is_array($plars) && empty($plars))) {
            unset($this->plars);
        } else {
            $this->plars = $plars;
        }
        return $this;
    }
}
