<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRegionMatrixReq StructType
 * @subpackage Structs
 */
class UpdateRegionMatrixReq extends APIRequest
{
    /**
     * The regionAName
     * Meta information extracted from the WSDL
     * - choice: uuid | regionAName | regionBName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionAName;
    /**
     * The regionBName
     * Meta information extracted from the WSDL
     * - choice: uuid | regionAName | regionBName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionBName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | regionAName | regionBName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The bandwidth
     * Meta information extracted from the WSDL
     * - documentation: The new bandwidth value for this particular region relationship.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta information extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $videoBandwidth;
    /**
     * The codecPreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $codecPreference;
    /**
     * Constructor method for UpdateRegionMatrixReq
     * @uses UpdateRegionMatrixReq::setRegionAName()
     * @uses UpdateRegionMatrixReq::setRegionBName()
     * @uses UpdateRegionMatrixReq::setUuid()
     * @uses UpdateRegionMatrixReq::setBandwidth()
     * @uses UpdateRegionMatrixReq::setVideoBandwidth()
     * @uses UpdateRegionMatrixReq::setCodecPreference()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName
     * @param string $uuid
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName = null, $uuid = null, $bandwidth = null, $videoBandwidth = '384', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null)
    {
        $this
            ->setRegionAName($regionAName)
            ->setRegionBName($regionBName)
            ->setUuid($uuid)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setCodecPreference($codecPreference);
    }
    /**
     * Get regionAName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRegionAName()
    {
        return isset($this->regionAName) ? $this->regionAName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRegionAName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegionAName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRegionANameForChoiceConstraintsFromSetRegionAName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'regionBName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property regionAName can\'t be set as the property %s is already set. Only one property must be set among these properties: regionAName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set regionAName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setRegionAName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName = null)
    {
        // validation for constraint: choice(uuid, regionAName, regionBName)
        if ('' !== ($regionANameChoiceErrorMessage = self::validateRegionANameForChoiceConstraintsFromSetRegionAName($regionAName))) {
            throw new \InvalidArgumentException($regionANameChoiceErrorMessage, __LINE__);
        }
        if (is_null($regionAName) || (is_array($regionAName) && empty($regionAName))) {
            unset($this->regionAName);
        } else {
            $this->regionAName = $regionAName;
        }
        return $this;
    }
    /**
     * Get regionBName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRegionBName()
    {
        return isset($this->regionBName) ? $this->regionBName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRegionBName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegionBName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRegionBNameForChoiceConstraintsFromSetRegionBName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'regionAName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property regionBName can\'t be set as the property %s is already set. Only one property must be set among these properties: regionBName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set regionBName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setRegionBName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName = null)
    {
        // validation for constraint: choice(uuid, regionAName, regionBName)
        if ('' !== ($regionBNameChoiceErrorMessage = self::validateRegionBNameForChoiceConstraintsFromSetRegionBName($regionBName))) {
            throw new \InvalidArgumentException($regionBNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($regionBName) || (is_array($regionBName) && empty($regionBName))) {
            unset($this->regionBName);
        } else {
            $this->regionBName = $regionBName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'regionAName',
            'regionBName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, regionAName, regionBName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @param string $bandwidth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth) && !is_string($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($videoBandwidth) ? implode(', ', $videoBandwidth) : var_export($videoBandwidth, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get codecPreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCodecPreference()
    {
        return isset($this->codecPreference) ? $this->codecPreference : null;
    }
    /**
     * Set codecPreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setCodecPreference(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null)
    {
        if (is_null($codecPreference) || (is_array($codecPreference) && empty($codecPreference))) {
            unset($this->codecPreference);
        } else {
            $this->codecPreference = $codecPreference;
        }
        return $this;
    }
}
