<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRecordingProfileReq StructType
 * @subpackage Structs
 */
class UpdateRecordingProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The recordingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $recordingCssName;
    /**
     * The recorderDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $recorderDestination;
    /**
     * Constructor method for UpdateRecordingProfileReq
     * @uses UpdateRecordingProfileReq::setNewName()
     * @uses UpdateRecordingProfileReq::setRecordingCssName()
     * @uses UpdateRecordingProfileReq::setRecorderDestination()
     * @param string $newName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingCssName
     * @param string $recorderDestination
     */
    public function __construct($newName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingCssName = null, $recorderDestination = null)
    {
        $this
            ->setNewName($newName)
            ->setRecordingCssName($recordingCssName)
            ->setRecorderDestination($recorderDestination);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRecordingProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get recordingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRecordingCssName()
    {
        return isset($this->recordingCssName) ? $this->recordingCssName : null;
    }
    /**
     * Set recordingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRecordingProfileReq
     */
    public function setRecordingCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingCssName = null)
    {
        if (is_null($recordingCssName) || (is_array($recordingCssName) && empty($recordingCssName))) {
            unset($this->recordingCssName);
        } else {
            $this->recordingCssName = $recordingCssName;
        }
        return $this;
    }
    /**
     * Get recorderDestination value
     * @return string|null
     */
    public function getRecorderDestination()
    {
        return $this->recorderDestination;
    }
    /**
     * Set recorderDestination value
     * @param string $recorderDestination
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateRecordingProfileReq
     */
    public function setRecorderDestination($recorderDestination = null)
    {
        // validation for constraint: string
        if (!is_null($recorderDestination) && !is_string($recorderDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recorderDestination, true), gettype($recorderDestination)), __LINE__);
        }
        $this->recorderDestination = $recorderDestination;
        return $this;
    }
}
