<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProcessNodeServiceReq StructType
 * @subpackage Structs
 */
class UpdateProcessNodeServiceReq extends APIRequest
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - choice: uuid | processNodeName | service
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - choice: uuid | processNodeName | service
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | processNodeName | service
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The traceLevel
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $traceLevel;
    /**
     * The userCategories
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userCategories;
    /**
     * The enable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enable;
    /**
     * The numFiles
     * Meta information extracted from the WSDL
     * - default: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numFiles;
    /**
     * The maxFileSize
     * Meta information extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxFileSize;
    /**
     * Constructor method for UpdateProcessNodeServiceReq
     * @uses UpdateProcessNodeServiceReq::setProcessNodeName()
     * @uses UpdateProcessNodeServiceReq::setService()
     * @uses UpdateProcessNodeServiceReq::setUuid()
     * @uses UpdateProcessNodeServiceReq::setTraceLevel()
     * @uses UpdateProcessNodeServiceReq::setUserCategories()
     * @uses UpdateProcessNodeServiceReq::setEnable()
     * @uses UpdateProcessNodeServiceReq::setNumFiles()
     * @uses UpdateProcessNodeServiceReq::setMaxFileSize()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param string $service
     * @param string $uuid
     * @param string $traceLevel
     * @param string $userCategories
     * @param string $enable
     * @param string $numFiles
     * @param string $maxFileSize
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, $service = null, $uuid = null, $traceLevel = '0', $userCategories = '0', $enable = 'false', $numFiles = '250', $maxFileSize = '1')
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setService($service)
            ->setUuid($uuid)
            ->setTraceLevel($traceLevel)
            ->setUserCategories($userCategories)
            ->setEnable($enable)
            ->setNumFiles($numFiles)
            ->setMaxFileSize($maxFileSize);
    }
    /**
     * Get processNodeName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return isset($this->processNodeName) ? $this->processNodeName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setProcessNodeName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcessNodeName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProcessNodeNameForChoiceConstraintsFromSetProcessNodeName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'service',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property processNodeName can\'t be set as the property %s is already set. Only one property must be set among these properties: processNodeName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set processNodeName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setProcessNodeName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        // validation for constraint: choice(uuid, processNodeName, service)
        if ('' !== ($processNodeNameChoiceErrorMessage = self::validateProcessNodeNameForChoiceConstraintsFromSetProcessNodeName($processNodeName))) {
            throw new \InvalidArgumentException($processNodeNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($processNodeName) || (is_array($processNodeName) && empty($processNodeName))) {
            unset($this->processNodeName);
        } else {
            $this->processNodeName = $processNodeName;
        }
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return isset($this->service) ? $this->service : null;
    }
    /**
     * This method is responsible for validating the value passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceForChoiceConstraintsFromSetService($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'processNodeName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property service can\'t be set as the property %s is already set. Only one property must be set among these properties: service, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set service value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XService::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XService', is_array($service) ? implode(', ', $service) : var_export($service, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XService::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(uuid, processNodeName, service)
        if ('' !== ($serviceChoiceErrorMessage = self::validateServiceForChoiceConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceChoiceErrorMessage, __LINE__);
        }
        if (is_null($service) || (is_array($service) && empty($service))) {
            unset($this->service);
        } else {
            $this->service = $service;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'processNodeName',
            'service',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, processNodeName, service)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get traceLevel value
     * @return string|null
     */
    public function getTraceLevel()
    {
        return $this->traceLevel;
    }
    /**
     * Set traceLevel value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traceLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setTraceLevel($traceLevel = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($traceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($traceLevel) ? implode(', ', $traceLevel) : var_export($traceLevel, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->traceLevel = $traceLevel;
        return $this;
    }
    /**
     * Get userCategories value
     * @return string|null
     */
    public function getUserCategories()
    {
        return $this->userCategories;
    }
    /**
     * Set userCategories value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userCategories
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setUserCategories($userCategories = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($userCategories)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($userCategories) ? implode(', ', $userCategories) : var_export($userCategories, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->userCategories = $userCategories;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setEnable($enable = 'false')
    {
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enable, true), gettype($enable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enable, true)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get numFiles value
     * @return string|null
     */
    public function getNumFiles()
    {
        return $this->numFiles;
    }
    /**
     * Set numFiles value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numFiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setNumFiles($numFiles = '250')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($numFiles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($numFiles) ? implode(', ', $numFiles) : var_export($numFiles, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numFiles = $numFiles;
        return $this;
    }
    /**
     * Get maxFileSize value
     * @return string|null
     */
    public function getMaxFileSize()
    {
        return $this->maxFileSize;
    }
    /**
     * Set maxFileSize value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxFileSize
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeServiceReq
     */
    public function setMaxFileSize($maxFileSize = '1')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxFileSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxFileSize) ? implode(', ', $maxFileSize) : var_export($maxFileSize, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxFileSize = $maxFileSize;
        return $this;
    }
}
