<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMohAudioSourceReq StructType
 * @subpackage Structs
 */
class UpdateMohAudioSourceReq extends APIRequest
{
    /**
     * The sourceId
     * Meta information extracted from the WSDL
     * - choice: uuid | sourceId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $sourceId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | sourceId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The sourceFile
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sourceFile;
    /**
     * The multicast
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The mohFileStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mohFileStatus;
    /**
     * The initialAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $initialAnnouncement;
    /**
     * The periodicAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $periodicAnnouncement;
    /**
     * The periodicAnnouncementInterval
     * Meta information extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $periodicAnnouncementInterval;
    /**
     * The localeAnnouncement
     * Meta information extracted from the WSDL
     * - default: English United States
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $localeAnnouncement;
    /**
     * The initialAnnouncementPlayed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $initialAnnouncementPlayed;
    /**
     * Constructor method for UpdateMohAudioSourceReq
     * @uses UpdateMohAudioSourceReq::setSourceId()
     * @uses UpdateMohAudioSourceReq::setUuid()
     * @uses UpdateMohAudioSourceReq::setNewName()
     * @uses UpdateMohAudioSourceReq::setSourceFile()
     * @uses UpdateMohAudioSourceReq::setMulticast()
     * @uses UpdateMohAudioSourceReq::setMohFileStatus()
     * @uses UpdateMohAudioSourceReq::setInitialAnnouncement()
     * @uses UpdateMohAudioSourceReq::setPeriodicAnnouncement()
     * @uses UpdateMohAudioSourceReq::setPeriodicAnnouncementInterval()
     * @uses UpdateMohAudioSourceReq::setLocaleAnnouncement()
     * @uses UpdateMohAudioSourceReq::setInitialAnnouncementPlayed()
     * @param string $sourceId
     * @param string $uuid
     * @param string $newName
     * @param string $sourceFile
     * @param string $multicast
     * @param string $mohFileStatus
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @param string $periodicAnnouncementInterval
     * @param string $localeAnnouncement
     * @param string $initialAnnouncementPlayed
     */
    public function __construct($sourceId = null, $uuid = null, $newName = null, $sourceFile = null, $multicast = null, $mohFileStatus = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null, $periodicAnnouncementInterval = '30', $localeAnnouncement = 'English United States', $initialAnnouncementPlayed = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setSourceFile($sourceFile)
            ->setMulticast($multicast)
            ->setMohFileStatus($mohFileStatus)
            ->setInitialAnnouncement($initialAnnouncement)
            ->setPeriodicAnnouncement($periodicAnnouncement)
            ->setPeriodicAnnouncementInterval($periodicAnnouncementInterval)
            ->setLocaleAnnouncement($localeAnnouncement)
            ->setInitialAnnouncementPlayed($initialAnnouncementPlayed);
    }
    /**
     * Get sourceId value
     * @return string
     */
    public function getSourceId()
    {
        return isset($this->sourceId) ? $this->sourceId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSourceId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSourceId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSourceIdForChoiceConstraintsFromSetSourceId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property sourceId can\'t be set as the property %s is already set. Only one property must be set among these properties: sourceId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set sourceId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($sourceId) ? implode(', ', $sourceId) : var_export($sourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(uuid, sourceId)
        if ('' !== ($sourceIdChoiceErrorMessage = self::validateSourceIdForChoiceConstraintsFromSetSourceId($sourceId))) {
            throw new \InvalidArgumentException($sourceIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->sourceId);
        } else {
            $this->sourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'sourceId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, sourceId)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get sourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->sourceFile;
    }
    /**
     * Set sourceFile value
     * @param string $sourceFile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setSourceFile($sourceFile = null)
    {
        // validation for constraint: string
        if (!is_null($sourceFile) && !is_string($sourceFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceFile, true), gettype($sourceFile)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($sourceFile) && mb_strlen($sourceFile) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($sourceFile)), __LINE__);
        }
        $this->sourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multicast, true), gettype($multicast)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($multicast, true)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get mohFileStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMohFileStatus()
    {
        return isset($this->mohFileStatus) ? $this->mohFileStatus : null;
    }
    /**
     * Set mohFileStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mohFileStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setMohFileStatus($mohFileStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($mohFileStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($mohFileStatus) ? implode(', ', $mohFileStatus) : var_export($mohFileStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($mohFileStatus) || (is_array($mohFileStatus) && empty($mohFileStatus))) {
            unset($this->mohFileStatus);
        } else {
            $this->mohFileStatus = $mohFileStatus;
        }
        return $this;
    }
    /**
     * Get initialAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInitialAnnouncement()
    {
        return isset($this->initialAnnouncement) ? $this->initialAnnouncement : null;
    }
    /**
     * Set initialAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setInitialAnnouncement(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null)
    {
        if (is_null($initialAnnouncement) || (is_array($initialAnnouncement) && empty($initialAnnouncement))) {
            unset($this->initialAnnouncement);
        } else {
            $this->initialAnnouncement = $initialAnnouncement;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPeriodicAnnouncement()
    {
        return isset($this->periodicAnnouncement) ? $this->periodicAnnouncement : null;
    }
    /**
     * Set periodicAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setPeriodicAnnouncement(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null)
    {
        if (is_null($periodicAnnouncement) || (is_array($periodicAnnouncement) && empty($periodicAnnouncement))) {
            unset($this->periodicAnnouncement);
        } else {
            $this->periodicAnnouncement = $periodicAnnouncement;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncementInterval value
     * @return string|null
     */
    public function getPeriodicAnnouncementInterval()
    {
        return $this->periodicAnnouncementInterval;
    }
    /**
     * Set periodicAnnouncementInterval value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicAnnouncementInterval
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setPeriodicAnnouncementInterval($periodicAnnouncementInterval = '30')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($periodicAnnouncementInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($periodicAnnouncementInterval) ? implode(', ', $periodicAnnouncementInterval) : var_export($periodicAnnouncementInterval, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->periodicAnnouncementInterval = $periodicAnnouncementInterval;
        return $this;
    }
    /**
     * Get localeAnnouncement value
     * @return string|null
     */
    public function getLocaleAnnouncement()
    {
        return $this->localeAnnouncement;
    }
    /**
     * Set localeAnnouncement value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $localeAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setLocaleAnnouncement($localeAnnouncement = 'English United States')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid($localeAnnouncement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale', is_array($localeAnnouncement) ? implode(', ', $localeAnnouncement) : var_export($localeAnnouncement, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->localeAnnouncement = $localeAnnouncement;
        return $this;
    }
    /**
     * Get initialAnnouncementPlayed value
     * @return string|null
     */
    public function getInitialAnnouncementPlayed()
    {
        return $this->initialAnnouncementPlayed;
    }
    /**
     * Set initialAnnouncementPlayed value
     * @param string $initialAnnouncementPlayed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setInitialAnnouncementPlayed($initialAnnouncementPlayed = null)
    {
        // validation for constraint: string
        if (!is_null($initialAnnouncementPlayed) && !is_string($initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialAnnouncementPlayed, true), gettype($initialAnnouncementPlayed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($initialAnnouncementPlayed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($initialAnnouncementPlayed, true)), __LINE__);
        }
        $this->initialAnnouncementPlayed = $initialAnnouncementPlayed;
        return $this;
    }
}
