<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMobileVoiceAccessReq StructType
 * @subpackage Structs
 */
class UpdateMobileVoiceAccessReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The removeLocales
     * Meta information extracted from the WSDL
     * - choice: removeLocales | addLocales | locales
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemoveLocales
     */
    public $removeLocales;
    /**
     * The addLocales
     * Meta information extracted from the WSDL
     * - choice: removeLocales | addLocales | locales
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddLocales
     */
    public $addLocales;
    /**
     * The locales
     * Meta information extracted from the WSDL
     * - choice: removeLocales | addLocales | locales
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Locales
     */
    public $locales;
    /**
     * Constructor method for UpdateMobileVoiceAccessReq
     * @uses UpdateMobileVoiceAccessReq::setPattern()
     * @uses UpdateMobileVoiceAccessReq::setUuid()
     * @uses UpdateMobileVoiceAccessReq::setNewPattern()
     * @uses UpdateMobileVoiceAccessReq::setRoutePartitionName()
     * @uses UpdateMobileVoiceAccessReq::setRemoveLocales()
     * @uses UpdateMobileVoiceAccessReq::setAddLocales()
     * @uses UpdateMobileVoiceAccessReq::setLocales()
     * @param string $pattern
     * @param string $uuid
     * @param string $newPattern
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveLocales $removeLocales
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLocales $addLocales
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Locales $locales
     */
    public function __construct($pattern = null, $uuid = null, $newPattern = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, \Losc\CucmBundle\Model\Webservice\StructType\RemoveLocales $removeLocales = null, \Losc\CucmBundle\Model\Webservice\StructType\AddLocales $addLocales = null, \Losc\CucmBundle\Model\Webservice\StructType\Locales $locales = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setRoutePartitionName($routePartitionName)
            ->setRemoveLocales($removeLocales)
            ->setAddLocales($addLocales)
            ->setLocales($locales);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePatternForChoiceConstraintsFromSetPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pattern can\'t be set as the property %s is already set. Only one property must be set among these properties: pattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($patternChoiceErrorMessage = self::validatePatternForChoiceConstraintsFromSetPattern($pattern))) {
            throw new \InvalidArgumentException($patternChoiceErrorMessage, __LINE__);
        }
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pattern',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPattern, true), gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get removeLocales value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveLocales|null
     */
    public function getRemoveLocales()
    {
        return isset($this->removeLocales) ? $this->removeLocales : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveLocales method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveLocales method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveLocalesForChoiceConstraintsFromSetRemoveLocales($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addLocales',
            'locales',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeLocales can\'t be set as the property %s is already set. Only one property must be set among these properties: removeLocales, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeLocales value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveLocales $removeLocales
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq
     */
    public function setRemoveLocales(\Losc\CucmBundle\Model\Webservice\StructType\RemoveLocales $removeLocales = null)
    {
        // validation for constraint: choice(removeLocales, addLocales, locales)
        if ('' !== ($removeLocalesChoiceErrorMessage = self::validateRemoveLocalesForChoiceConstraintsFromSetRemoveLocales($removeLocales))) {
            throw new \InvalidArgumentException($removeLocalesChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeLocales) || (is_array($removeLocales) && empty($removeLocales))) {
            unset($this->removeLocales);
        } else {
            $this->removeLocales = $removeLocales;
        }
        return $this;
    }
    /**
     * Get addLocales value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddLocales|null
     */
    public function getAddLocales()
    {
        return isset($this->addLocales) ? $this->addLocales : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddLocales method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddLocales method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddLocalesForChoiceConstraintsFromSetAddLocales($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeLocales',
            'locales',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addLocales can\'t be set as the property %s is already set. Only one property must be set among these properties: addLocales, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addLocales value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddLocales $addLocales
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq
     */
    public function setAddLocales(\Losc\CucmBundle\Model\Webservice\StructType\AddLocales $addLocales = null)
    {
        // validation for constraint: choice(removeLocales, addLocales, locales)
        if ('' !== ($addLocalesChoiceErrorMessage = self::validateAddLocalesForChoiceConstraintsFromSetAddLocales($addLocales))) {
            throw new \InvalidArgumentException($addLocalesChoiceErrorMessage, __LINE__);
        }
        if (is_null($addLocales) || (is_array($addLocales) && empty($addLocales))) {
            unset($this->addLocales);
        } else {
            $this->addLocales = $addLocales;
        }
        return $this;
    }
    /**
     * Get locales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Locales|null
     */
    public function getLocales()
    {
        return isset($this->locales) ? $this->locales : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLocales method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocales method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLocalesForChoiceConstraintsFromSetLocales($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeLocales',
            'addLocales',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property locales can\'t be set as the property %s is already set. Only one property must be set among these properties: locales, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set locales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Locales $locales
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateMobileVoiceAccessReq
     */
    public function setLocales(\Losc\CucmBundle\Model\Webservice\StructType\Locales $locales = null)
    {
        // validation for constraint: choice(removeLocales, addLocales, locales)
        if ('' !== ($localesChoiceErrorMessage = self::validateLocalesForChoiceConstraintsFromSetLocales($locales))) {
            throw new \InvalidArgumentException($localesChoiceErrorMessage, __LINE__);
        }
        if (is_null($locales) || (is_array($locales) && empty($locales))) {
            unset($this->locales);
        } else {
            $this->locales = $locales;
        }
        return $this;
    }
}
