<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLineGroupReq StructType
 * @subpackage Structs
 */
class UpdateLineGroupReq extends NameAndGUIDRequest
{
    /**
     * The distributionAlgorithm
     * Meta information extracted from the WSDL
     * - default: Longest Idle Time
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The rnaReversionTimeOut
     * Meta information extracted from the WSDL
     * - default: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rnaReversionTimeOut;
    /**
     * The huntAlgorithmNoAnswer
     * Meta information extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNoAnswer;
    /**
     * The huntAlgorithmBusy
     * Meta information extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmBusy;
    /**
     * The huntAlgorithmNotAvailable
     * Meta information extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNotAvailable;
    /**
     * The removeMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The autoLogOffHunt
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoLogOffHunt;
    /**
     * Constructor method for UpdateLineGroupReq
     * @uses UpdateLineGroupReq::setDistributionAlgorithm()
     * @uses UpdateLineGroupReq::setRnaReversionTimeOut()
     * @uses UpdateLineGroupReq::setHuntAlgorithmNoAnswer()
     * @uses UpdateLineGroupReq::setHuntAlgorithmBusy()
     * @uses UpdateLineGroupReq::setHuntAlgorithmNotAvailable()
     * @uses UpdateLineGroupReq::setRemoveMembers()
     * @uses UpdateLineGroupReq::setAddMembers()
     * @uses UpdateLineGroupReq::setMembers()
     * @uses UpdateLineGroupReq::setNewName()
     * @uses UpdateLineGroupReq::setAutoLogOffHunt()
     * @param string $distributionAlgorithm
     * @param string $rnaReversionTimeOut
     * @param string $huntAlgorithmNoAnswer
     * @param string $huntAlgorithmBusy
     * @param string $huntAlgorithmNotAvailable
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param string $newName
     * @param string $autoLogOffHunt
     */
    public function __construct($distributionAlgorithm = 'Longest Idle Time', $rnaReversionTimeOut = '10', $huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List', $huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List', $huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List', \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers = null, \Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, $newName = null, $autoLogOffHunt = 'false')
    {
        $this
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setRnaReversionTimeOut($rnaReversionTimeOut)
            ->setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer)
            ->setHuntAlgorithmBusy($huntAlgorithmBusy)
            ->setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setNewName($newName)
            ->setAutoLogOffHunt($autoLogOffHunt);
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setDistributionAlgorithm($distributionAlgorithm = 'Longest Idle Time')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm', is_array($distributionAlgorithm) ? implode(', ', $distributionAlgorithm) : var_export($distributionAlgorithm, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get rnaReversionTimeOut value
     * @return string|null
     */
    public function getRnaReversionTimeOut()
    {
        return $this->rnaReversionTimeOut;
    }
    /**
     * Set rnaReversionTimeOut value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rnaReversionTimeOut
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setRnaReversionTimeOut($rnaReversionTimeOut = '10')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($rnaReversionTimeOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($rnaReversionTimeOut) ? implode(', ', $rnaReversionTimeOut) : var_export($rnaReversionTimeOut, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rnaReversionTimeOut = $rnaReversionTimeOut;
        return $this;
    }
    /**
     * Get huntAlgorithmNoAnswer value
     * @return string|null
     */
    public function getHuntAlgorithmNoAnswer()
    {
        return $this->huntAlgorithmNoAnswer;
    }
    /**
     * Set huntAlgorithmNoAnswer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNoAnswer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm', is_array($huntAlgorithmNoAnswer) ? implode(', ', $huntAlgorithmNoAnswer) : var_export($huntAlgorithmNoAnswer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNoAnswer = $huntAlgorithmNoAnswer;
        return $this;
    }
    /**
     * Get huntAlgorithmBusy value
     * @return string|null
     */
    public function getHuntAlgorithmBusy()
    {
        return $this->huntAlgorithmBusy;
    }
    /**
     * Set huntAlgorithmBusy value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmBusy
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmBusy($huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmBusy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm', is_array($huntAlgorithmBusy) ? implode(', ', $huntAlgorithmBusy) : var_export($huntAlgorithmBusy, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmBusy = $huntAlgorithmBusy;
        return $this;
    }
    /**
     * Get huntAlgorithmNotAvailable value
     * @return string|null
     */
    public function getHuntAlgorithmNotAvailable()
    {
        return $this->huntAlgorithmNotAvailable;
    }
    /**
     * Set huntAlgorithmNotAvailable value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNotAvailable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNotAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm', is_array($huntAlgorithmNotAvailable) ? implode(', ', $huntAlgorithmNotAvailable) : var_export($huntAlgorithmNotAvailable, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNotAvailable = $huntAlgorithmNotAvailable;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return isset($this->removeMembers) ? $this->removeMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: removeMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setRemoveMembers(\Losc\CucmBundle\Model\Webservice\StructType\RemoveMembers $removeMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($removeMembersChoiceErrorMessage = self::validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($removeMembers))) {
            throw new \InvalidArgumentException($removeMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeMembers) || (is_array($removeMembers) && empty($removeMembers))) {
            unset($this->removeMembers);
        } else {
            $this->removeMembers = $removeMembers;
        }
        return $this;
    }
    /**
     * Get addMembers value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return isset($this->addMembers) ? $this->addMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddMembersForChoiceConstraintsFromSetAddMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: addMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setAddMembers(\Losc\CucmBundle\Model\Webservice\StructType\AddMembers $addMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($addMembersChoiceErrorMessage = self::validateAddMembersForChoiceConstraintsFromSetAddMembers($addMembers))) {
            throw new \InvalidArgumentException($addMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($addMembers) || (is_array($addMembers) && empty($addMembers))) {
            unset($this->addMembers);
        } else {
            $this->addMembers = $addMembers;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members|null
     */
    public function getMembers()
    {
        return isset($this->members) ? $this->members : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMembersForChoiceConstraintsFromSetMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'addMembers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property members can\'t be set as the property %s is already set. Only one property must be set among these properties: members, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set members value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($membersChoiceErrorMessage = self::validateMembersForChoiceConstraintsFromSetMembers($members))) {
            throw new \InvalidArgumentException($membersChoiceErrorMessage, __LINE__);
        }
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->members);
        } else {
            $this->members = $members;
        }
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get autoLogOffHunt value
     * @return string|null
     */
    public function getAutoLogOffHunt()
    {
        return $this->autoLogOffHunt;
    }
    /**
     * Set autoLogOffHunt value
     * @param string $autoLogOffHunt
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateLineGroupReq
     */
    public function setAutoLogOffHunt($autoLogOffHunt = 'false')
    {
        // validation for constraint: string
        if (!is_null($autoLogOffHunt) && !is_string($autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoLogOffHunt, true), gettype($autoLogOffHunt)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($autoLogOffHunt) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoLogOffHunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($autoLogOffHunt, true)), __LINE__);
        }
        $this->autoLogOffHunt = $autoLogOffHunt;
        return $this;
    }
}
