<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIpPhoneServicesReq StructType
 * @subpackage Structs
 */
class UpdateIpPhoneServicesReq extends APIRequest
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | serviceName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | serviceName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newServiceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newServiceName;
    /**
     * The asciiServiceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceDescription;
    /**
     * The serviceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceUrl;
    /**
     * The secureServiceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceCategory
     * Meta information extracted from the WSDL
     * - default: XML Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - default: Standard IP Phone Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The serviceVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The removeParameters
     * Meta information extracted from the WSDL
     * - choice: removeParameters | addParameters | parameters
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters
     */
    public $removeParameters;
    /**
     * The addParameters
     * Meta information extracted from the WSDL
     * - choice: removeParameters | addParameters | parameters
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddParameters
     */
    public $addParameters;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - choice: removeParameters | addParameters | parameters
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Parameters
     */
    public $parameters;
    /**
     * Constructor method for UpdateIpPhoneServicesReq
     * @uses UpdateIpPhoneServicesReq::setServiceName()
     * @uses UpdateIpPhoneServicesReq::setUuid()
     * @uses UpdateIpPhoneServicesReq::setNewServiceName()
     * @uses UpdateIpPhoneServicesReq::setAsciiServiceName()
     * @uses UpdateIpPhoneServicesReq::setServiceDescription()
     * @uses UpdateIpPhoneServicesReq::setServiceUrl()
     * @uses UpdateIpPhoneServicesReq::setSecureServiceUrl()
     * @uses UpdateIpPhoneServicesReq::setServiceCategory()
     * @uses UpdateIpPhoneServicesReq::setServiceType()
     * @uses UpdateIpPhoneServicesReq::setServiceVendor()
     * @uses UpdateIpPhoneServicesReq::setServiceVersion()
     * @uses UpdateIpPhoneServicesReq::setEnabled()
     * @uses UpdateIpPhoneServicesReq::setRemoveParameters()
     * @uses UpdateIpPhoneServicesReq::setAddParameters()
     * @uses UpdateIpPhoneServicesReq::setParameters()
     * @param string $serviceName
     * @param string $uuid
     * @param string $newServiceName
     * @param string $asciiServiceName
     * @param string $serviceDescription
     * @param string $serviceUrl
     * @param string $secureServiceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters
     */
    public function __construct($serviceName = null, $uuid = null, $newServiceName = null, $asciiServiceName = null, $serviceDescription = null, $serviceUrl = null, $secureServiceUrl = null, $serviceCategory = 'XML Service', $serviceType = 'Standard IP Phone Service', $serviceVendor = null, $serviceVersion = null, $enabled = 'true', \Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters = null, \Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters = null, \Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setUuid($uuid)
            ->setNewServiceName($newServiceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceDescription($serviceDescription)
            ->setServiceUrl($serviceUrl)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setRemoveParameters($removeParameters)
            ->setAddParameters($addParameters)
            ->setParameters($parameters);
    }
    /**
     * Get serviceName value
     * @return string
     */
    public function getServiceName()
    {
        return isset($this->serviceName) ? $this->serviceName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceNameForChoiceConstraintsFromSetServiceName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property serviceName can\'t be set as the property %s is already set. Only one property must be set among these properties: serviceName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set serviceName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $serviceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        // validation for constraint: choice(uuid, serviceName)
        if ('' !== ($serviceNameChoiceErrorMessage = self::validateServiceNameForChoiceConstraintsFromSetServiceName($serviceName))) {
            throw new \InvalidArgumentException($serviceNameChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($serviceName) && mb_strlen($serviceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->serviceName);
        } else {
            $this->serviceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'serviceName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, serviceName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newServiceName value
     * @return string|null
     */
    public function getNewServiceName()
    {
        return $this->newServiceName;
    }
    /**
     * Set newServiceName value
     * @param string $newServiceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setNewServiceName($newServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($newServiceName) && !is_string($newServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newServiceName, true), gettype($newServiceName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($newServiceName) && mb_strlen($newServiceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($newServiceName)), __LINE__);
        }
        $this->newServiceName = $newServiceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string|null
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($asciiServiceName) && !is_string($asciiServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asciiServiceName, true), gettype($asciiServiceName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($asciiServiceName) && mb_strlen($asciiServiceName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($asciiServiceName)), __LINE__);
        }
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDescription()
    {
        return isset($this->serviceDescription) ? $this->serviceDescription : null;
    }
    /**
     * Set serviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDescription
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDescription, true), gettype($serviceDescription)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($serviceDescription) && mb_strlen($serviceDescription) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($serviceDescription)), __LINE__);
        }
        if (is_null($serviceDescription) || (is_array($serviceDescription) && empty($serviceDescription))) {
            unset($this->serviceDescription);
        } else {
            $this->serviceDescription = $serviceDescription;
        }
        return $this;
    }
    /**
     * Get serviceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceUrl()
    {
        return isset($this->serviceUrl) ? $this->serviceUrl : null;
    }
    /**
     * Set serviceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceUrl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceUrl($serviceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($serviceUrl) && !is_string($serviceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceUrl, true), gettype($serviceUrl)), __LINE__);
        }
        if (is_null($serviceUrl) || (is_array($serviceUrl) && empty($serviceUrl))) {
            unset($this->serviceUrl);
        } else {
            $this->serviceUrl = $serviceUrl;
        }
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return isset($this->secureServiceUrl) ? $this->secureServiceUrl : null;
    }
    /**
     * Set secureServiceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secureServiceUrl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServiceUrl) && !is_string($secureServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureServiceUrl, true), gettype($secureServiceUrl)), __LINE__);
        }
        if (is_null($secureServiceUrl) || (is_array($secureServiceUrl) && empty($secureServiceUrl))) {
            unset($this->secureServiceUrl);
        } else {
            $this->secureServiceUrl = $secureServiceUrl;
        }
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string|null
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCategory
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceCategory($serviceCategory = 'XML Service')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::valueIsValid($serviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory', is_array($serviceCategory) ? implode(', ', $serviceCategory) : var_export($serviceCategory, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneServiceCategory::getValidValues())), __LINE__);
        }
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceType($serviceType = 'Standard IP Phone Service')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPhoneService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceVendor($serviceVendor = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVendor) && !is_string($serviceVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceVendor, true), gettype($serviceVendor)), __LINE__);
        }
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVersion) && !is_string($serviceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceVersion, true), gettype($serviceVersion)), __LINE__);
        }
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setEnabled($enabled = 'true')
    {
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enabled, true)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get removeParameters value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters|null
     */
    public function getRemoveParameters()
    {
        return isset($this->removeParameters) ? $this->removeParameters : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveParameters method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveParametersForChoiceConstraintsFromSetRemoveParameters($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addParameters',
            'parameters',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeParameters can\'t be set as the property %s is already set. Only one property must be set among these properties: removeParameters, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeParameters value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setRemoveParameters(\Losc\CucmBundle\Model\Webservice\StructType\RemoveParameters $removeParameters = null)
    {
        // validation for constraint: choice(removeParameters, addParameters, parameters)
        if ('' !== ($removeParametersChoiceErrorMessage = self::validateRemoveParametersForChoiceConstraintsFromSetRemoveParameters($removeParameters))) {
            throw new \InvalidArgumentException($removeParametersChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeParameters) || (is_array($removeParameters) && empty($removeParameters))) {
            unset($this->removeParameters);
        } else {
            $this->removeParameters = $removeParameters;
        }
        return $this;
    }
    /**
     * Get addParameters value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddParameters|null
     */
    public function getAddParameters()
    {
        return isset($this->addParameters) ? $this->addParameters : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddParameters method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddParametersForChoiceConstraintsFromSetAddParameters($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeParameters',
            'parameters',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addParameters can\'t be set as the property %s is already set. Only one property must be set among these properties: addParameters, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addParameters value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setAddParameters(\Losc\CucmBundle\Model\Webservice\StructType\AddParameters $addParameters = null)
    {
        // validation for constraint: choice(removeParameters, addParameters, parameters)
        if ('' !== ($addParametersChoiceErrorMessage = self::validateAddParametersForChoiceConstraintsFromSetAddParameters($addParameters))) {
            throw new \InvalidArgumentException($addParametersChoiceErrorMessage, __LINE__);
        }
        if (is_null($addParameters) || (is_array($addParameters) && empty($addParameters))) {
            unset($this->addParameters);
        } else {
            $this->addParameters = $addParameters;
        }
        return $this;
    }
    /**
     * Get parameters value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Parameters|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * This method is responsible for validating the value passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateParametersForChoiceConstraintsFromSetParameters($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeParameters',
            'addParameters',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property parameters can\'t be set as the property %s is already set. Only one property must be set among these properties: parameters, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set parameters value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateIpPhoneServicesReq
     */
    public function setParameters(\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters = null)
    {
        // validation for constraint: choice(removeParameters, addParameters, parameters)
        if ('' !== ($parametersChoiceErrorMessage = self::validateParametersForChoiceConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersChoiceErrorMessage, __LINE__);
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
}
