<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeE164TransformationReq StructType
 * @subpackage Structs
 */
class UpdateImeE164TransformationReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The isCgpnPreTransformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCgpnPreTransformation;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The isCdpnPreTransformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCdpnPreTransformation;
    /**
     * The incomingCgpnTransformationProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $incomingCgpnTransformationProfileName;
    /**
     * The incomingCdpnTransformationProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $incomingCdpnTransformationProfileName;
    /**
     * Constructor method for UpdateImeE164TransformationReq
     * @uses UpdateImeE164TransformationReq::setNewName()
     * @uses UpdateImeE164TransformationReq::setDescription()
     * @uses UpdateImeE164TransformationReq::setCgpnTransformationCssName()
     * @uses UpdateImeE164TransformationReq::setIsCgpnPreTransformation()
     * @uses UpdateImeE164TransformationReq::setCdpnTransformationCssName()
     * @uses UpdateImeE164TransformationReq::setIsCdpnPreTransformation()
     * @uses UpdateImeE164TransformationReq::setIncomingCgpnTransformationProfileName()
     * @uses UpdateImeE164TransformationReq::setIncomingCdpnTransformationProfileName()
     * @param string $newName
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $isCgpnPreTransformation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $isCdpnPreTransformation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName
     */
    public function __construct($newName = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $isCgpnPreTransformation = 'false', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $isCdpnPreTransformation = 'false', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setIsCgpnPreTransformation($isCgpnPreTransformation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setIsCdpnPreTransformation($isCdpnPreTransformation)
            ->setIncomingCgpnTransformationProfileName($incomingCgpnTransformationProfileName)
            ->setIncomingCdpnTransformationProfileName($incomingCdpnTransformationProfileName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setCgpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get isCgpnPreTransformation value
     * @return string|null
     */
    public function getIsCgpnPreTransformation()
    {
        return $this->isCgpnPreTransformation;
    }
    /**
     * Set isCgpnPreTransformation value
     * @param string $isCgpnPreTransformation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setIsCgpnPreTransformation($isCgpnPreTransformation = 'false')
    {
        // validation for constraint: string
        if (!is_null($isCgpnPreTransformation) && !is_string($isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isCgpnPreTransformation, true), gettype($isCgpnPreTransformation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isCgpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isCgpnPreTransformation, true)), __LINE__);
        }
        $this->isCgpnPreTransformation = $isCgpnPreTransformation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setCdpnTransformationCssName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get isCdpnPreTransformation value
     * @return string|null
     */
    public function getIsCdpnPreTransformation()
    {
        return $this->isCdpnPreTransformation;
    }
    /**
     * Set isCdpnPreTransformation value
     * @param string $isCdpnPreTransformation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setIsCdpnPreTransformation($isCdpnPreTransformation = 'false')
    {
        // validation for constraint: string
        if (!is_null($isCdpnPreTransformation) && !is_string($isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isCdpnPreTransformation, true), gettype($isCdpnPreTransformation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isCdpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isCdpnPreTransformation, true)), __LINE__);
        }
        $this->isCdpnPreTransformation = $isCdpnPreTransformation;
        return $this;
    }
    /**
     * Get incomingCgpnTransformationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getIncomingCgpnTransformationProfileName()
    {
        return isset($this->incomingCgpnTransformationProfileName) ? $this->incomingCgpnTransformationProfileName : null;
    }
    /**
     * Set incomingCgpnTransformationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setIncomingCgpnTransformationProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName = null)
    {
        if (is_null($incomingCgpnTransformationProfileName) || (is_array($incomingCgpnTransformationProfileName) && empty($incomingCgpnTransformationProfileName))) {
            unset($this->incomingCgpnTransformationProfileName);
        } else {
            $this->incomingCgpnTransformationProfileName = $incomingCgpnTransformationProfileName;
        }
        return $this;
    }
    /**
     * Get incomingCdpnTransformationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getIncomingCdpnTransformationProfileName()
    {
        return isset($this->incomingCdpnTransformationProfileName) ? $this->incomingCdpnTransformationProfileName : null;
    }
    /**
     * Set incomingCdpnTransformationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateImeE164TransformationReq
     */
    public function setIncomingCdpnTransformationProfileName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        if (is_null($incomingCdpnTransformationProfileName) || (is_array($incomingCdpnTransformationProfileName) && empty($incomingCdpnTransformationProfileName))) {
            unset($this->incomingCdpnTransformationProfileName);
        } else {
            $this->incomingCdpnTransformationProfileName = $incomingCdpnTransformationProfileName;
        }
        return $this;
    }
}
