<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFixedMohAudioSourceReq StructType
 * @subpackage Structs
 */
class UpdateFixedMohAudioSourceReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The multicast
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The enable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $enable;
    /**
     * The initialAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $initialAnnouncement;
    /**
     * The periodicAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $periodicAnnouncement;
    /**
     * The periodicAnnouncementInterval
     * Meta information extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $periodicAnnouncementInterval;
    /**
     * The localeAnnouncement
     * Meta information extracted from the WSDL
     * - default: English United States
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $localeAnnouncement;
    /**
     * The initialAnnouncementPlayed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $initialAnnouncementPlayed;
    /**
     * Constructor method for UpdateFixedMohAudioSourceReq
     * @uses UpdateFixedMohAudioSourceReq::setNewName()
     * @uses UpdateFixedMohAudioSourceReq::setMulticast()
     * @uses UpdateFixedMohAudioSourceReq::setEnable()
     * @uses UpdateFixedMohAudioSourceReq::setInitialAnnouncement()
     * @uses UpdateFixedMohAudioSourceReq::setPeriodicAnnouncement()
     * @uses UpdateFixedMohAudioSourceReq::setPeriodicAnnouncementInterval()
     * @uses UpdateFixedMohAudioSourceReq::setLocaleAnnouncement()
     * @uses UpdateFixedMohAudioSourceReq::setInitialAnnouncementPlayed()
     * @param string $newName
     * @param string $multicast
     * @param string $enable
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @param string $periodicAnnouncementInterval
     * @param string $localeAnnouncement
     * @param string $initialAnnouncementPlayed
     */
    public function __construct($newName = null, $multicast = null, $enable = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null, $periodicAnnouncementInterval = '30', $localeAnnouncement = 'English United States', $initialAnnouncementPlayed = null)
    {
        $this
            ->setNewName($newName)
            ->setMulticast($multicast)
            ->setEnable($enable)
            ->setInitialAnnouncement($initialAnnouncement)
            ->setPeriodicAnnouncement($periodicAnnouncement)
            ->setPeriodicAnnouncementInterval($periodicAnnouncementInterval)
            ->setLocaleAnnouncement($localeAnnouncement)
            ->setInitialAnnouncementPlayed($initialAnnouncementPlayed);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multicast, true), gettype($multicast)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($multicast, true)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enable, true), gettype($enable)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get initialAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInitialAnnouncement()
    {
        return isset($this->initialAnnouncement) ? $this->initialAnnouncement : null;
    }
    /**
     * Set initialAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setInitialAnnouncement(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null)
    {
        if (is_null($initialAnnouncement) || (is_array($initialAnnouncement) && empty($initialAnnouncement))) {
            unset($this->initialAnnouncement);
        } else {
            $this->initialAnnouncement = $initialAnnouncement;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPeriodicAnnouncement()
    {
        return isset($this->periodicAnnouncement) ? $this->periodicAnnouncement : null;
    }
    /**
     * Set periodicAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setPeriodicAnnouncement(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null)
    {
        if (is_null($periodicAnnouncement) || (is_array($periodicAnnouncement) && empty($periodicAnnouncement))) {
            unset($this->periodicAnnouncement);
        } else {
            $this->periodicAnnouncement = $periodicAnnouncement;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncementInterval value
     * @return string|null
     */
    public function getPeriodicAnnouncementInterval()
    {
        return $this->periodicAnnouncementInterval;
    }
    /**
     * Set periodicAnnouncementInterval value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicAnnouncementInterval
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setPeriodicAnnouncementInterval($periodicAnnouncementInterval = '30')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($periodicAnnouncementInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($periodicAnnouncementInterval) ? implode(', ', $periodicAnnouncementInterval) : var_export($periodicAnnouncementInterval, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->periodicAnnouncementInterval = $periodicAnnouncementInterval;
        return $this;
    }
    /**
     * Get localeAnnouncement value
     * @return string|null
     */
    public function getLocaleAnnouncement()
    {
        return $this->localeAnnouncement;
    }
    /**
     * Set localeAnnouncement value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $localeAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setLocaleAnnouncement($localeAnnouncement = 'English United States')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid($localeAnnouncement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale', is_array($localeAnnouncement) ? implode(', ', $localeAnnouncement) : var_export($localeAnnouncement, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->localeAnnouncement = $localeAnnouncement;
        return $this;
    }
    /**
     * Get initialAnnouncementPlayed value
     * @return string|null
     */
    public function getInitialAnnouncementPlayed()
    {
        return $this->initialAnnouncementPlayed;
    }
    /**
     * Set initialAnnouncementPlayed value
     * @param string $initialAnnouncementPlayed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateFixedMohAudioSourceReq
     */
    public function setInitialAnnouncementPlayed($initialAnnouncementPlayed = null)
    {
        // validation for constraint: string
        if (!is_null($initialAnnouncementPlayed) && !is_string($initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialAnnouncementPlayed, true), gettype($initialAnnouncementPlayed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($initialAnnouncementPlayed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($initialAnnouncementPlayed, true)), __LINE__);
        }
        $this->initialAnnouncementPlayed = $initialAnnouncementPlayed;
        return $this;
    }
}
