<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCcdRequestingServiceReq StructType
 * @subpackage Structs
 */
class UpdateCcdRequestingServiceReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The learnedPatternPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The pstnPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnPrefix;
    /**
     * The removeAssociatedTrunks
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedTrunks | addAssociatedTrunks | associatedTrunks
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedTrunks
     */
    public $removeAssociatedTrunks;
    /**
     * The addAssociatedTrunks
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedTrunks | addAssociatedTrunks | associatedTrunks
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedTrunks
     */
    public $addAssociatedTrunks;
    /**
     * The associatedTrunks
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedTrunks | addAssociatedTrunks | associatedTrunks
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks
     */
    public $associatedTrunks;
    /**
     * Constructor method for UpdateCcdRequestingServiceReq
     * @uses UpdateCcdRequestingServiceReq::setNewName()
     * @uses UpdateCcdRequestingServiceReq::setDescription()
     * @uses UpdateCcdRequestingServiceReq::setIsActivated()
     * @uses UpdateCcdRequestingServiceReq::setRoutePartitionName()
     * @uses UpdateCcdRequestingServiceReq::setLearnedPatternPrefix()
     * @uses UpdateCcdRequestingServiceReq::setPstnPrefix()
     * @uses UpdateCcdRequestingServiceReq::setRemoveAssociatedTrunks()
     * @uses UpdateCcdRequestingServiceReq::setAddAssociatedTrunks()
     * @uses UpdateCcdRequestingServiceReq::setAssociatedTrunks()
     * @param string $newName
     * @param string $description
     * @param string $isActivated
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $learnedPatternPrefix
     * @param string $pstnPrefix
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedTrunks $removeAssociatedTrunks
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedTrunks $addAssociatedTrunks
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks
     */
    public function __construct($newName = null, $description = null, $isActivated = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $learnedPatternPrefix = null, $pstnPrefix = null, \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedTrunks $removeAssociatedTrunks = null, \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedTrunks $addAssociatedTrunks = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setRoutePartitionName($routePartitionName)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setPstnPrefix($pstnPrefix)
            ->setRemoveAssociatedTrunks($removeAssociatedTrunks)
            ->setAddAssociatedTrunks($addAssociatedTrunks)
            ->setAssociatedTrunks($associatedTrunks);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($learnedPatternPrefix, true), gettype($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($learnedPatternPrefix) && mb_strlen($learnedPatternPrefix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get pstnPrefix value
     * @return string|null
     */
    public function getPstnPrefix()
    {
        return $this->pstnPrefix;
    }
    /**
     * Set pstnPrefix value
     * @param string $pstnPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setPstnPrefix($pstnPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($pstnPrefix) && !is_string($pstnPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnPrefix, true), gettype($pstnPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pstnPrefix) && mb_strlen($pstnPrefix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($pstnPrefix)), __LINE__);
        }
        $this->pstnPrefix = $pstnPrefix;
        return $this;
    }
    /**
     * Get removeAssociatedTrunks value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedTrunks|null
     */
    public function getRemoveAssociatedTrunks()
    {
        return isset($this->removeAssociatedTrunks) ? $this->removeAssociatedTrunks : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveAssociatedTrunks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveAssociatedTrunks method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveAssociatedTrunksForChoiceConstraintsFromSetRemoveAssociatedTrunks($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addAssociatedTrunks',
            'associatedTrunks',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeAssociatedTrunks can\'t be set as the property %s is already set. Only one property must be set among these properties: removeAssociatedTrunks, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeAssociatedTrunks value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedTrunks $removeAssociatedTrunks
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setRemoveAssociatedTrunks(\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedTrunks $removeAssociatedTrunks = null)
    {
        // validation for constraint: choice(removeAssociatedTrunks, addAssociatedTrunks, associatedTrunks)
        if ('' !== ($removeAssociatedTrunksChoiceErrorMessage = self::validateRemoveAssociatedTrunksForChoiceConstraintsFromSetRemoveAssociatedTrunks($removeAssociatedTrunks))) {
            throw new \InvalidArgumentException($removeAssociatedTrunksChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeAssociatedTrunks) || (is_array($removeAssociatedTrunks) && empty($removeAssociatedTrunks))) {
            unset($this->removeAssociatedTrunks);
        } else {
            $this->removeAssociatedTrunks = $removeAssociatedTrunks;
        }
        return $this;
    }
    /**
     * Get addAssociatedTrunks value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedTrunks|null
     */
    public function getAddAssociatedTrunks()
    {
        return isset($this->addAssociatedTrunks) ? $this->addAssociatedTrunks : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddAssociatedTrunks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddAssociatedTrunks method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddAssociatedTrunksForChoiceConstraintsFromSetAddAssociatedTrunks($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeAssociatedTrunks',
            'associatedTrunks',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addAssociatedTrunks can\'t be set as the property %s is already set. Only one property must be set among these properties: addAssociatedTrunks, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addAssociatedTrunks value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedTrunks $addAssociatedTrunks
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setAddAssociatedTrunks(\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedTrunks $addAssociatedTrunks = null)
    {
        // validation for constraint: choice(removeAssociatedTrunks, addAssociatedTrunks, associatedTrunks)
        if ('' !== ($addAssociatedTrunksChoiceErrorMessage = self::validateAddAssociatedTrunksForChoiceConstraintsFromSetAddAssociatedTrunks($addAssociatedTrunks))) {
            throw new \InvalidArgumentException($addAssociatedTrunksChoiceErrorMessage, __LINE__);
        }
        if (is_null($addAssociatedTrunks) || (is_array($addAssociatedTrunks) && empty($addAssociatedTrunks))) {
            unset($this->addAssociatedTrunks);
        } else {
            $this->addAssociatedTrunks = $addAssociatedTrunks;
        }
        return $this;
    }
    /**
     * Get associatedTrunks value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks|null
     */
    public function getAssociatedTrunks()
    {
        return isset($this->associatedTrunks) ? $this->associatedTrunks : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAssociatedTrunks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssociatedTrunks method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAssociatedTrunksForChoiceConstraintsFromSetAssociatedTrunks($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeAssociatedTrunks',
            'addAssociatedTrunks',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property associatedTrunks can\'t be set as the property %s is already set. Only one property must be set among these properties: associatedTrunks, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set associatedTrunks value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdRequestingServiceReq
     */
    public function setAssociatedTrunks(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedTrunks $associatedTrunks = null)
    {
        // validation for constraint: choice(removeAssociatedTrunks, addAssociatedTrunks, associatedTrunks)
        if ('' !== ($associatedTrunksChoiceErrorMessage = self::validateAssociatedTrunksForChoiceConstraintsFromSetAssociatedTrunks($associatedTrunks))) {
            throw new \InvalidArgumentException($associatedTrunksChoiceErrorMessage, __LINE__);
        }
        if (is_null($associatedTrunks) || (is_array($associatedTrunks) && empty($associatedTrunks))) {
            unset($this->associatedTrunks);
        } else {
            $this->associatedTrunks = $associatedTrunks;
        }
        return $this;
    }
}
