<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateBillingServerReq StructType
 * @subpackage Structs
 */
class UpdateBillingServerReq extends APIRequest
{
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The resendOnFailure
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $resendOnFailure;
    /**
     * The billingServerProtocol
     * Meta information extracted from the WSDL
     * - default: SFTP
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $billingServerProtocol;
    /**
     * Constructor method for UpdateBillingServerReq
     * @uses UpdateBillingServerReq::setUuid()
     * @uses UpdateBillingServerReq::setUserId()
     * @uses UpdateBillingServerReq::setPassword()
     * @uses UpdateBillingServerReq::setResendOnFailure()
     * @uses UpdateBillingServerReq::setBillingServerProtocol()
     * @param string $uuid
     * @param string $userId
     * @param string $password
     * @param string $resendOnFailure
     * @param string $billingServerProtocol
     */
    public function __construct($uuid = null, $userId = null, $password = null, $resendOnFailure = 'true', $billingServerProtocol = 'SFTP')
    {
        $this
            ->setUuid($uuid)
            ->setUserId($userId)
            ->setPassword($password)
            ->setResendOnFailure($resendOnFailure)
            ->setBillingServerProtocol($billingServerProtocol);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get resendOnFailure value
     * @return string|null
     */
    public function getResendOnFailure()
    {
        return $this->resendOnFailure;
    }
    /**
     * Set resendOnFailure value
     * @param string $resendOnFailure
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setResendOnFailure($resendOnFailure = 'true')
    {
        // validation for constraint: string
        if (!is_null($resendOnFailure) && !is_string($resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resendOnFailure, true), gettype($resendOnFailure)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($resendOnFailure) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($resendOnFailure, true)), __LINE__);
        }
        $this->resendOnFailure = $resendOnFailure;
        return $this;
    }
    /**
     * Get billingServerProtocol value
     * @return string|null
     */
    public function getBillingServerProtocol()
    {
        return $this->billingServerProtocol;
    }
    /**
     * Set billingServerProtocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billingServerProtocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setBillingServerProtocol($billingServerProtocol = 'SFTP')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::valueIsValid($billingServerProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol', is_array($billingServerProtocol) ? implode(', ', $billingServerProtocol) : var_export($billingServerProtocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XBillingserverprotocol::getValidValues())), __LINE__);
        }
        $this->billingServerProtocol = $billingServerProtocol;
        return $this;
    }
}
