<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAarGroupMatrixReq StructType
 * @subpackage Structs
 */
class UpdateAarGroupMatrixReq extends APIRequest
{
    /**
     * The aarGroupFromName
     * Meta information extracted from the WSDL
     * - choice: uuid | aarGroupFromName | aarGroupToName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta information extracted from the WSDL
     * - choice: uuid | aarGroupFromName | aarGroupToName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarGroupToName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | aarGroupFromName | aarGroupToName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The prefixDigit
     * Meta information extracted from the WSDL
     * - documentation: The new prefixDigit value for this particular AARGroup relationship.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $prefixDigit;
    /**
     * Constructor method for UpdateAarGroupMatrixReq
     * @uses UpdateAarGroupMatrixReq::setAarGroupFromName()
     * @uses UpdateAarGroupMatrixReq::setAarGroupToName()
     * @uses UpdateAarGroupMatrixReq::setUuid()
     * @uses UpdateAarGroupMatrixReq::setPrefixDigit()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName
     * @param string $uuid
     * @param string $prefixDigit
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName = null, $uuid = null, $prefixDigit = null)
    {
        $this
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName)
            ->setUuid($uuid)
            ->setPrefixDigit($prefixDigit);
    }
    /**
     * Get aarGroupFromName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getAarGroupFromName()
    {
        return isset($this->aarGroupFromName) ? $this->aarGroupFromName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAarGroupFromName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAarGroupFromName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAarGroupFromNameForChoiceConstraintsFromSetAarGroupFromName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'aarGroupToName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property aarGroupFromName can\'t be set as the property %s is already set. Only one property must be set among these properties: aarGroupFromName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set aarGroupFromName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupMatrixReq
     */
    public function setAarGroupFromName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupFromName = null)
    {
        // validation for constraint: choice(uuid, aarGroupFromName, aarGroupToName)
        if ('' !== ($aarGroupFromNameChoiceErrorMessage = self::validateAarGroupFromNameForChoiceConstraintsFromSetAarGroupFromName($aarGroupFromName))) {
            throw new \InvalidArgumentException($aarGroupFromNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($aarGroupFromName) || (is_array($aarGroupFromName) && empty($aarGroupFromName))) {
            unset($this->aarGroupFromName);
        } else {
            $this->aarGroupFromName = $aarGroupFromName;
        }
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getAarGroupToName()
    {
        return isset($this->aarGroupToName) ? $this->aarGroupToName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAarGroupToName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAarGroupToName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAarGroupToNameForChoiceConstraintsFromSetAarGroupToName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'aarGroupFromName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property aarGroupToName can\'t be set as the property %s is already set. Only one property must be set among these properties: aarGroupToName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set aarGroupToName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupMatrixReq
     */
    public function setAarGroupToName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarGroupToName = null)
    {
        // validation for constraint: choice(uuid, aarGroupFromName, aarGroupToName)
        if ('' !== ($aarGroupToNameChoiceErrorMessage = self::validateAarGroupToNameForChoiceConstraintsFromSetAarGroupToName($aarGroupToName))) {
            throw new \InvalidArgumentException($aarGroupToNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($aarGroupToName) || (is_array($aarGroupToName) && empty($aarGroupToName))) {
            unset($this->aarGroupToName);
        } else {
            $this->aarGroupToName = $aarGroupToName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'aarGroupFromName',
            'aarGroupToName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupMatrixReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, aarGroupFromName, aarGroupToName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\UpdateAarGroupMatrixReq
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigit, true), gettype($prefixDigit)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($prefixDigit) && mb_strlen($prefixDigit) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
}
