<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for servers StructType
 * @subpackage Structs
 */
class Servers extends AbstractStructBase
{
    /**
     * The server
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Server[]
     */
    public $server;
    /**
     * Constructor method for servers
     * @uses Servers::setServer()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Server[] $server
     */
    public function __construct(array $server = array())
    {
        $this
            ->setServer($server);
    }
    /**
     * Get server value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Server[]|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * This method is responsible for validating the values passed to the setServer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServerForArrayConstraintsFromSetServer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serversServerItem) {
            // validation for constraint: itemType
            if (!$serversServerItem instanceof \Losc\CucmBundle\Model\Webservice\StructType\Server) {
                $invalidValues[] = is_object($serversServerItem) ? get_class($serversServerItem) : sprintf('%s(%s)', gettype($serversServerItem), var_export($serversServerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The server property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\Server, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set server value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Server[] $server
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public function setServer(array $server = array())
    {
        // validation for constraint: array
        if ('' !== ($serverArrayErrorMessage = self::validateServerForArrayConstraintsFromSetServer($server))) {
            throw new \InvalidArgumentException($serverArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($server) && count($server) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($server)), __LINE__);
        }
        $this->server = $server;
        return $this;
    }
    /**
     * Add item to server value
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Server $item
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public function addToServer(\Losc\CucmBundle\Model\Webservice\StructType\Server $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Losc\CucmBundle\Model\Webservice\StructType\Server) {
            throw new \InvalidArgumentException(sprintf('The server property can only contain items of type \Losc\CucmBundle\Model\Webservice\StructType\Server, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->server) && count($this->server) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->server)), __LINE__);
        }
        $this->server[] = $item;
        return $this;
    }
}
