<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveRoutePatternReq StructType
 * @subpackage Structs
 */
class RemoveRoutePatternReq extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - documentation: dialPlan is mandatory for patterns with @ in it.
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveRoutePatternReq
     * @uses RemoveRoutePatternReq::setPattern()
     * @uses RemoveRoutePatternReq::setRoutePartitionName()
     * @uses RemoveRoutePatternReq::setDialPlanName()
     * @uses RemoveRoutePatternReq::setRouteFilterName()
     * @uses RemoveRoutePatternReq::setUuid()
     * @uses RemoveRoutePatternReq::setSequence()
     * @param string $pattern
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($pattern = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $uuid = null, $sequence = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setDialPlanName($dialPlanName)
            ->setRouteFilterName($routeFilterName)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePatternForChoiceConstraintsFromSetPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'routePartitionName',
            'dialPlanName',
            'routeFilterName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pattern can\'t be set as the property %s is already set. Only one property must be set among these properties: pattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pattern
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern, routePartitionName, dialPlanName, routeFilterName)
        if ('' !== ($patternChoiceErrorMessage = self::validatePatternForChoiceConstraintsFromSetPattern($pattern))) {
            throw new \InvalidArgumentException($patternChoiceErrorMessage, __LINE__);
        }
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRoutePartitionName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoutePartitionName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRoutePartitionNameForChoiceConstraintsFromSetRoutePartitionName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'pattern',
            'dialPlanName',
            'routeFilterName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property routePartitionName can\'t be set as the property %s is already set. Only one property must be set among these properties: routePartitionName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set routePartitionName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        // validation for constraint: choice(uuid, pattern, routePartitionName, dialPlanName, routeFilterName)
        if ('' !== ($routePartitionNameChoiceErrorMessage = self::validateRoutePartitionNameForChoiceConstraintsFromSetRoutePartitionName($routePartitionName))) {
            throw new \InvalidArgumentException($routePartitionNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDialPlanName()
    {
        return isset($this->dialPlanName) ? $this->dialPlanName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDialPlanName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDialPlanName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDialPlanNameForChoiceConstraintsFromSetDialPlanName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'pattern',
            'routePartitionName',
            'routeFilterName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dialPlanName can\'t be set as the property %s is already set. Only one property must be set among these properties: dialPlanName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dialPlanName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq
     */
    public function setDialPlanName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        // validation for constraint: choice(uuid, pattern, routePartitionName, dialPlanName, routeFilterName)
        if ('' !== ($dialPlanNameChoiceErrorMessage = self::validateDialPlanNameForChoiceConstraintsFromSetDialPlanName($dialPlanName))) {
            throw new \InvalidArgumentException($dialPlanNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($dialPlanName) || (is_array($dialPlanName) && empty($dialPlanName))) {
            unset($this->dialPlanName);
        } else {
            $this->dialPlanName = $dialPlanName;
        }
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRouteFilterName()
    {
        return isset($this->routeFilterName) ? $this->routeFilterName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRouteFilterName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRouteFilterName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRouteFilterNameForChoiceConstraintsFromSetRouteFilterName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'pattern',
            'routePartitionName',
            'dialPlanName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property routeFilterName can\'t be set as the property %s is already set. Only one property must be set among these properties: routeFilterName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set routeFilterName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq
     */
    public function setRouteFilterName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        // validation for constraint: choice(uuid, pattern, routePartitionName, dialPlanName, routeFilterName)
        if ('' !== ($routeFilterNameChoiceErrorMessage = self::validateRouteFilterNameForChoiceConstraintsFromSetRouteFilterName($routeFilterName))) {
            throw new \InvalidArgumentException($routeFilterNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($routeFilterName) || (is_array($routeFilterName) && empty($routeFilterName))) {
            unset($this->routeFilterName);
        } else {
            $this->routeFilterName = $routeFilterName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pattern',
            'routePartitionName',
            'dialPlanName',
            'routeFilterName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern, routePartitionName, dialPlanName, routeFilterName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RemoveRoutePatternReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
