<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RWifiHotspot StructType
 * @subpackage Structs
 */
class RWifiHotspot extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The ssidPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ssidPrefix;
    /**
     * The userModifiable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userModifiable;
    /**
     * The frequencyBand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $frequencyBand;
    /**
     * The authenticationMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMethod;
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostName;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The sharedSecret
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sharedSecret;
    /**
     * The pskPassPhrase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pskPassPhrase;
    /**
     * The wepKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $passwordDescription;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RWifiHotspot
     * @uses RWifiHotspot::setName()
     * @uses RWifiHotspot::setDescription()
     * @uses RWifiHotspot::setSsidPrefix()
     * @uses RWifiHotspot::setUserModifiable()
     * @uses RWifiHotspot::setFrequencyBand()
     * @uses RWifiHotspot::setAuthenticationMethod()
     * @uses RWifiHotspot::setHostName()
     * @uses RWifiHotspot::setPort()
     * @uses RWifiHotspot::setSharedSecret()
     * @uses RWifiHotspot::setPskPassPhrase()
     * @uses RWifiHotspot::setWepKey()
     * @uses RWifiHotspot::setPasswordDescription()
     * @uses RWifiHotspot::setUuid()
     * @param string $name
     * @param string $description
     * @param string $ssidPrefix
     * @param string $userModifiable
     * @param string $frequencyBand
     * @param string $authenticationMethod
     * @param string $hostName
     * @param string $port
     * @param string $sharedSecret
     * @param string $pskPassPhrase
     * @param string $wepKey
     * @param string $passwordDescription
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $ssidPrefix = null, $userModifiable = null, $frequencyBand = null, $authenticationMethod = null, $hostName = null, $port = null, $sharedSecret = null, $pskPassPhrase = null, $wepKey = null, $passwordDescription = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSsidPrefix($ssidPrefix)
            ->setUserModifiable($userModifiable)
            ->setFrequencyBand($frequencyBand)
            ->setAuthenticationMethod($authenticationMethod)
            ->setHostName($hostName)
            ->setPort($port)
            ->setSharedSecret($sharedSecret)
            ->setPskPassPhrase($pskPassPhrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string|null
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($ssidPrefix) && !is_string($ssidPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssidPrefix, true), gettype($ssidPrefix)), __LINE__);
        }
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setUserModifiable($userModifiable = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges', is_array($userModifiable) ? implode(', ', $userModifiable) : var_export($userModifiable, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string|null
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setFrequencyBand($frequencyBand = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency', is_array($frequencyBand) ? implode(', ', $frequencyBand) : var_export($frequencyBand, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string|null
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMethod
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setAuthenticationMethod($authenticationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::valueIsValid($authenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod', is_array($authenticationMethod) ? implode(', ', $authenticationMethod) : var_export($authenticationMethod, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XHotspotAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostName, true), gettype($hostName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($hostName) && mb_strlen($hostName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get sharedSecret value
     * @return string|null
     */
    public function getSharedSecret()
    {
        return $this->sharedSecret;
    }
    /**
     * Set sharedSecret value
     * @param string $sharedSecret
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setSharedSecret($sharedSecret = null)
    {
        // validation for constraint: string
        if (!is_null($sharedSecret) && !is_string($sharedSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedSecret, true), gettype($sharedSecret)), __LINE__);
        }
        $this->sharedSecret = $sharedSecret;
        return $this;
    }
    /**
     * Get pskPassPhrase value
     * @return string|null
     */
    public function getPskPassPhrase()
    {
        return $this->pskPassPhrase;
    }
    /**
     * Set pskPassPhrase value
     * @param string $pskPassPhrase
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setPskPassPhrase($pskPassPhrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassPhrase) && !is_string($pskPassPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pskPassPhrase, true), gettype($pskPassPhrase)), __LINE__);
        }
        $this->pskPassPhrase = $pskPassPhrase;
        return $this;
    }
    /**
     * Get wepKey value
     * @return string|null
     */
    public function getWepKey()
    {
        return $this->wepKey;
    }
    /**
     * Set wepKey value
     * @param string $wepKey
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wepKey, true), gettype($wepKey)), __LINE__);
        }
        $this->wepKey = $wepKey;
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordDescription, true), gettype($passwordDescription)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($passwordDescription) && mb_strlen($passwordDescription) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RWifiHotspot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
