<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUser StructType
 * @subpackage Structs
 */
class RUser extends AbstractStructBase
{
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The mailid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailid;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The manager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manager;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The primaryExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension
     */
    public $primaryExtension;
    /**
     * The associatedPc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $associatedPc;
    /**
     * The associatedGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The enableCti
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCti;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The phoneProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles
     */
    public $phoneProfiles;
    /**
     * The defaultProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultProfile;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The enableMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWaitTime
     * Meta information extracted from the WSDL
     * - documentation: Maximum wait time for Desk Pickup must be a number in the range 0 to 30000.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxDeskPickupWaitTime;
    /**
     * The remoteDestinationLimit
     * Meta information extracted from the WSDL
     * - documentation: Remote Destination Limit must be a number in the range 1 to 10. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The associatedRemoteDestinationProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles
     */
    public $associatedRemoteDestinationProfiles;
    /**
     * The passwordCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The pinCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials
     */
    public $pinCredentials;
    /**
     * The primaryDevice
     * Meta information extracted from the WSDL
     * - documentation: Primary Device for mobility users
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryDevice;
    /**
     * The associatedTodAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess
     */
    public $associatedTodAccess;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The enableEmcc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEmcc;
    /**
     * The associatedCapfProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles
     */
    public $associatedCapfProfiles;
    /**
     * The ctiControlledDeviceProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The numericUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numericUserId;
    /**
     * The mlppPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppPassword;
    /**
     * The customUserFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields
     */
    public $customUserFields;
    /**
     * The homeCluster
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndPresenceEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndPresenceEnable;
    /**
     * The serviceProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $serviceProfile;
    /**
     * The lineAppearanceAssociationForPresences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences
     */
    public $lineAppearanceAssociationForPresences;
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUri;
    /**
     * The telephoneNumber
     * Meta information extracted from the WSDL
     * - documentation: This field also corresponds to the field 'Number Displayed in Directory' for the Quick User/phone Add page.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telephoneNumber;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The mobileNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mobileNumber;
    /**
     * The homeNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $homeNumber;
    /**
     * The pagerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pagerNumber;
    /**
     * The extensionsInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo
     */
    public $extensionsInfo;
    /**
     * The selfService
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selfService;
    /**
     * The userProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $userProfile;
    /**
     * The calendarPresence
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $calendarPresence;
    /**
     * The ldapDirectoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ldapDirectoryName;
    /**
     * The userIdentity
     * Meta information extracted from the WSDL
     * - documentation: Value should be of of the format user@domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userIdentity;
    /**
     * The nameDialing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nameDialing;
    /**
     * The ipccExtension
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Controlled Devices so this tag is appropriate for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ipccExtension;
    /**
     * The convertUserAccount
     * Meta information extracted from the WSDL
     * - documentation: These tags are for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $convertUserAccount;
    /**
     * The accountType
     * Meta information extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies this is a Locally created user and a value of 'LDAP' implies this user is an LDAP Synchronized user
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountType;
    /**
     * The authenticationType
     * Meta information extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies authentication will happen at CUCM and a value of 'LDAP' implies authentication will happen at the LDAP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationType;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUser
     * @uses RUser::setFirstName()
     * @uses RUser::setMiddleName()
     * @uses RUser::setLastName()
     * @uses RUser::setUserid()
     * @uses RUser::setPassword()
     * @uses RUser::setPin()
     * @uses RUser::setMailid()
     * @uses RUser::setDepartment()
     * @uses RUser::setManager()
     * @uses RUser::setUserLocale()
     * @uses RUser::setAssociatedDevices()
     * @uses RUser::setPrimaryExtension()
     * @uses RUser::setAssociatedPc()
     * @uses RUser::setAssociatedGroups()
     * @uses RUser::setEnableCti()
     * @uses RUser::setDigestCredentials()
     * @uses RUser::setPhoneProfiles()
     * @uses RUser::setDefaultProfile()
     * @uses RUser::setPresenceGroupName()
     * @uses RUser::setSubscribeCallingSearchSpaceName()
     * @uses RUser::setEnableMobility()
     * @uses RUser::setEnableMobileVoiceAccess()
     * @uses RUser::setMaxDeskPickupWaitTime()
     * @uses RUser::setRemoteDestinationLimit()
     * @uses RUser::setAssociatedRemoteDestinationProfiles()
     * @uses RUser::setPasswordCredentials()
     * @uses RUser::setPinCredentials()
     * @uses RUser::setPrimaryDevice()
     * @uses RUser::setAssociatedTodAccess()
     * @uses RUser::setStatus()
     * @uses RUser::setEnableEmcc()
     * @uses RUser::setAssociatedCapfProfiles()
     * @uses RUser::setCtiControlledDeviceProfiles()
     * @uses RUser::setPatternPrecedence()
     * @uses RUser::setNumericUserId()
     * @uses RUser::setMlppPassword()
     * @uses RUser::setCustomUserFields()
     * @uses RUser::setHomeCluster()
     * @uses RUser::setImAndPresenceEnable()
     * @uses RUser::setServiceProfile()
     * @uses RUser::setLineAppearanceAssociationForPresences()
     * @uses RUser::setDirectoryUri()
     * @uses RUser::setTelephoneNumber()
     * @uses RUser::setTitle()
     * @uses RUser::setMobileNumber()
     * @uses RUser::setHomeNumber()
     * @uses RUser::setPagerNumber()
     * @uses RUser::setExtensionsInfo()
     * @uses RUser::setSelfService()
     * @uses RUser::setUserProfile()
     * @uses RUser::setCalendarPresence()
     * @uses RUser::setLdapDirectoryName()
     * @uses RUser::setUserIdentity()
     * @uses RUser::setNameDialing()
     * @uses RUser::setIpccExtension()
     * @uses RUser::setConvertUserAccount()
     * @uses RUser::setAccountType()
     * @uses RUser::setAuthenticationType()
     * @uses RUser::setUuid()
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $userid
     * @param string $password
     * @param string $pin
     * @param string $mailid
     * @param string $department
     * @param string $manager
     * @param string $userLocale
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension
     * @param string $associatedPc
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @param string $enableCti
     * @param string $digestCredentials
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWaitTime
     * @param string $remoteDestinationLimit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess $associatedTodAccess
     * @param string $status
     * @param string $enableEmcc
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $patternPrecedence
     * @param string $numericUserId
     * @param string $mlppPassword
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields
     * @param string $homeCluster
     * @param string $imAndPresenceEnable
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @param string $directoryUri
     * @param string $telephoneNumber
     * @param string $title
     * @param string $mobileNumber
     * @param string $homeNumber
     * @param string $pagerNumber
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo
     * @param string $selfService
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @param string $calendarPresence
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName
     * @param string $userIdentity
     * @param string $nameDialing
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount
     * @param string $accountType
     * @param string $authenticationType
     * @param string $uuid
     */
    public function __construct($firstName = null, $middleName = null, $lastName = null, $userid = null, $password = null, $pin = null, $mailid = null, $department = null, $manager = null, $userLocale = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null, \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension = null, $associatedPc = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null, $enableCti = null, $digestCredentials = null, \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, $enableMobility = null, $enableMobileVoiceAccess = null, $maxDeskPickupWaitTime = null, $remoteDestinationLimit = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles = null, \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null, \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess $associatedTodAccess = null, $status = null, $enableEmcc = null, \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null, \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $patternPrecedence = null, $numericUserId = null, $mlppPassword = null, \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields = null, $homeCluster = null, $imAndPresenceEnable = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null, \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null, $directoryUri = null, $telephoneNumber = null, $title = null, $mobileNumber = null, $homeNumber = null, $pagerNumber = null, \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo = null, $selfService = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null, $calendarPresence = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName = null, $userIdentity = null, $nameDialing = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount = null, $accountType = null, $authenticationType = null, $uuid = null)
    {
        $this
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setUserid($userid)
            ->setPassword($password)
            ->setPin($pin)
            ->setMailid($mailid)
            ->setDepartment($department)
            ->setManager($manager)
            ->setUserLocale($userLocale)
            ->setAssociatedDevices($associatedDevices)
            ->setPrimaryExtension($primaryExtension)
            ->setAssociatedPc($associatedPc)
            ->setAssociatedGroups($associatedGroups)
            ->setEnableCti($enableCti)
            ->setDigestCredentials($digestCredentials)
            ->setPhoneProfiles($phoneProfiles)
            ->setDefaultProfile($defaultProfile)
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWaitTime($maxDeskPickupWaitTime)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setAssociatedRemoteDestinationProfiles($associatedRemoteDestinationProfiles)
            ->setPasswordCredentials($passwordCredentials)
            ->setPinCredentials($pinCredentials)
            ->setPrimaryDevice($primaryDevice)
            ->setAssociatedTodAccess($associatedTodAccess)
            ->setStatus($status)
            ->setEnableEmcc($enableEmcc)
            ->setAssociatedCapfProfiles($associatedCapfProfiles)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setPatternPrecedence($patternPrecedence)
            ->setNumericUserId($numericUserId)
            ->setMlppPassword($mlppPassword)
            ->setCustomUserFields($customUserFields)
            ->setHomeCluster($homeCluster)
            ->setImAndPresenceEnable($imAndPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setLineAppearanceAssociationForPresences($lineAppearanceAssociationForPresences)
            ->setDirectoryUri($directoryUri)
            ->setTelephoneNumber($telephoneNumber)
            ->setTitle($title)
            ->setMobileNumber($mobileNumber)
            ->setHomeNumber($homeNumber)
            ->setPagerNumber($pagerNumber)
            ->setExtensionsInfo($extensionsInfo)
            ->setSelfService($selfService)
            ->setUserProfile($userProfile)
            ->setCalendarPresence($calendarPresence)
            ->setLdapDirectoryName($ldapDirectoryName)
            ->setUserIdentity($userIdentity)
            ->setNameDialing($nameDialing)
            ->setIpccExtension($ipccExtension)
            ->setConvertUserAccount($convertUserAccount)
            ->setAccountType($accountType)
            ->setAuthenticationType($authenticationType)
            ->setUuid($uuid);
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pin, true), gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get mailid value
     * @return string|null
     */
    public function getMailid()
    {
        return $this->mailid;
    }
    /**
     * Set mailid value
     * @param string $mailid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setMailid($mailid = null)
    {
        // validation for constraint: string
        if (!is_null($mailid) && !is_string($mailid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailid, true), gettype($mailid)), __LINE__);
        }
        $this->mailid = $mailid;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manager, true), gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale', is_array($userLocale) ? implode(', ', $userLocale) : var_export($userLocale, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAssociatedDevices(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get primaryExtension value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension|null
     */
    public function getPrimaryExtension()
    {
        return $this->primaryExtension;
    }
    /**
     * Set primaryExtension value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPrimaryExtension(\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension = null)
    {
        $this->primaryExtension = $primaryExtension;
        return $this;
    }
    /**
     * Get associatedPc value
     * @return string|null
     */
    public function getAssociatedPc()
    {
        return $this->associatedPc;
    }
    /**
     * Set associatedPc value
     * @param string $associatedPc
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAssociatedPc($associatedPc = null)
    {
        // validation for constraint: string
        if (!is_null($associatedPc) && !is_string($associatedPc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedPc, true), gettype($associatedPc)), __LINE__);
        }
        $this->associatedPc = $associatedPc;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAssociatedGroups(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get enableCti value
     * @return string|null
     */
    public function getEnableCti()
    {
        return $this->enableCti;
    }
    /**
     * Set enableCti value
     * @param string $enableCti
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setEnableCti($enableCti = null)
    {
        // validation for constraint: string
        if (!is_null($enableCti) && !is_string($enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableCti, true), gettype($enableCti)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableCti, true)), __LINE__);
        }
        $this->enableCti = $enableCti;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestCredentials, true), gettype($digestCredentials)), __LINE__);
        }
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get phoneProfiles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles|null
     */
    public function getPhoneProfiles()
    {
        return $this->phoneProfiles;
    }
    /**
     * Set phoneProfiles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPhoneProfiles(\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles = null)
    {
        $this->phoneProfiles = $phoneProfiles;
        return $this;
    }
    /**
     * Get defaultProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultProfile()
    {
        return $this->defaultProfile;
    }
    /**
     * Set defaultProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setDefaultProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile = null)
    {
        $this->defaultProfile = $defaultProfile;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPresenceGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setSubscribeCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setEnableMobility($enableMobility = null)
    {
        // validation for constraint: string
        if (!is_null($enableMobility) && !is_string($enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobility, true), gettype($enableMobility)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobility, true)), __LINE__);
        }
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = null)
    {
        // validation for constraint: string
        if (!is_null($enableMobileVoiceAccess) && !is_string($enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobileVoiceAccess, true), gettype($enableMobileVoiceAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobileVoiceAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobileVoiceAccess, true)), __LINE__);
        }
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWaitTime value
     * @return string|null
     */
    public function getMaxDeskPickupWaitTime()
    {
        return $this->maxDeskPickupWaitTime;
    }
    /**
     * Set maxDeskPickupWaitTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxDeskPickupWaitTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setMaxDeskPickupWaitTime($maxDeskPickupWaitTime = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($maxDeskPickupWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($maxDeskPickupWaitTime) ? implode(', ', $maxDeskPickupWaitTime) : var_export($maxDeskPickupWaitTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxDeskPickupWaitTime = $maxDeskPickupWaitTime;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteDestinationLimit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($remoteDestinationLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($remoteDestinationLimit) ? implode(', ', $remoteDestinationLimit) : var_export($remoteDestinationLimit, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get associatedRemoteDestinationProfiles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles|null
     */
    public function getAssociatedRemoteDestinationProfiles()
    {
        return $this->associatedRemoteDestinationProfiles;
    }
    /**
     * Set associatedRemoteDestinationProfiles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAssociatedRemoteDestinationProfiles(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles = null)
    {
        $this->associatedRemoteDestinationProfiles = $associatedRemoteDestinationProfiles;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPasswordCredentials(\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get pinCredentials value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials|null
     */
    public function getPinCredentials()
    {
        return $this->pinCredentials;
    }
    /**
     * Set pinCredentials value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPinCredentials(\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials = null)
    {
        $this->pinCredentials = $pinCredentials;
        return $this;
    }
    /**
     * Get primaryDevice value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPrimaryDevice()
    {
        return $this->primaryDevice;
    }
    /**
     * Set primaryDevice value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPrimaryDevice(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice = null)
    {
        $this->primaryDevice = $primaryDevice;
        return $this;
    }
    /**
     * Get associatedTodAccess value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess|null
     */
    public function getAssociatedTodAccess()
    {
        return $this->associatedTodAccess;
    }
    /**
     * Set associatedTodAccess value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess $associatedTodAccess
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAssociatedTodAccess(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedTodAccess $associatedTodAccess = null)
    {
        $this->associatedTodAccess = $associatedTodAccess;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get enableEmcc value
     * @return string|null
     */
    public function getEnableEmcc()
    {
        return $this->enableEmcc;
    }
    /**
     * Set enableEmcc value
     * @param string $enableEmcc
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setEnableEmcc($enableEmcc = null)
    {
        // validation for constraint: string
        if (!is_null($enableEmcc) && !is_string($enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableEmcc, true), gettype($enableEmcc)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableEmcc) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableEmcc, true)), __LINE__);
        }
        $this->enableEmcc = $enableEmcc;
        return $this;
    }
    /**
     * Get associatedCapfProfiles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles|null
     */
    public function getAssociatedCapfProfiles()
    {
        return $this->associatedCapfProfiles;
    }
    /**
     * Set associatedCapfProfiles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAssociatedCapfProfiles(\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null)
    {
        $this->associatedCapfProfiles = $associatedCapfProfiles;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setCtiControlledDeviceProfiles(\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence', is_array($patternPrecedence) ? implode(', ', $patternPrecedence) : var_export($patternPrecedence, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get numericUserId value
     * @return string|null
     */
    public function getNumericUserId()
    {
        return $this->numericUserId;
    }
    /**
     * Set numericUserId value
     * @param string $numericUserId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setNumericUserId($numericUserId = null)
    {
        // validation for constraint: string
        if (!is_null($numericUserId) && !is_string($numericUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numericUserId, true), gettype($numericUserId)), __LINE__);
        }
        $this->numericUserId = $numericUserId;
        return $this;
    }
    /**
     * Get mlppPassword value
     * @return string|null
     */
    public function getMlppPassword()
    {
        return $this->mlppPassword;
    }
    /**
     * Set mlppPassword value
     * @param string $mlppPassword
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setMlppPassword($mlppPassword = null)
    {
        // validation for constraint: string
        if (!is_null($mlppPassword) && !is_string($mlppPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppPassword, true), gettype($mlppPassword)), __LINE__);
        }
        $this->mlppPassword = $mlppPassword;
        return $this;
    }
    /**
     * Get customUserFields value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields|null
     */
    public function getCustomUserFields()
    {
        return $this->customUserFields;
    }
    /**
     * Set customUserFields value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setCustomUserFields(\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields = null)
    {
        $this->customUserFields = $customUserFields;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setHomeCluster($homeCluster = null)
    {
        // validation for constraint: string
        if (!is_null($homeCluster) && !is_string($homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeCluster, true), gettype($homeCluster)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($homeCluster) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($homeCluster, true)), __LINE__);
        }
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndPresenceEnable value
     * @return string|null
     */
    public function getImAndPresenceEnable()
    {
        return $this->imAndPresenceEnable;
    }
    /**
     * Set imAndPresenceEnable value
     * @param string $imAndPresenceEnable
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setImAndPresenceEnable($imAndPresenceEnable = null)
    {
        // validation for constraint: string
        if (!is_null($imAndPresenceEnable) && !is_string($imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imAndPresenceEnable, true), gettype($imAndPresenceEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($imAndPresenceEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($imAndPresenceEnable, true)), __LINE__);
        }
        $this->imAndPresenceEnable = $imAndPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServiceProfile()
    {
        return $this->serviceProfile;
    }
    /**
     * Set serviceProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setServiceProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null)
    {
        $this->serviceProfile = $serviceProfile;
        return $this;
    }
    /**
     * Get lineAppearanceAssociationForPresences value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences|null
     */
    public function getLineAppearanceAssociationForPresences()
    {
        return $this->lineAppearanceAssociationForPresences;
    }
    /**
     * Set lineAppearanceAssociationForPresences value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setLineAppearanceAssociationForPresences(\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null)
    {
        $this->lineAppearanceAssociationForPresences = $lineAppearanceAssociationForPresences;
        return $this;
    }
    /**
     * Get directoryUri value
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * Set directoryUri value
     * @param string $directoryUri
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setDirectoryUri($directoryUri = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUri) && !is_string($directoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryUri, true), gettype($directoryUri)), __LINE__);
        }
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephoneNumber, true), gettype($telephoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($telephoneNumber) && mb_strlen($telephoneNumber) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get mobileNumber value
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->mobileNumber;
    }
    /**
     * Set mobileNumber value
     * @param string $mobileNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setMobileNumber($mobileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNumber) && !is_string($mobileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileNumber, true), gettype($mobileNumber)), __LINE__);
        }
        $this->mobileNumber = $mobileNumber;
        return $this;
    }
    /**
     * Get homeNumber value
     * @return string|null
     */
    public function getHomeNumber()
    {
        return $this->homeNumber;
    }
    /**
     * Set homeNumber value
     * @param string $homeNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setHomeNumber($homeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homeNumber) && !is_string($homeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeNumber, true), gettype($homeNumber)), __LINE__);
        }
        $this->homeNumber = $homeNumber;
        return $this;
    }
    /**
     * Get pagerNumber value
     * @return string|null
     */
    public function getPagerNumber()
    {
        return $this->pagerNumber;
    }
    /**
     * Set pagerNumber value
     * @param string $pagerNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setPagerNumber($pagerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pagerNumber) && !is_string($pagerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pagerNumber, true), gettype($pagerNumber)), __LINE__);
        }
        $this->pagerNumber = $pagerNumber;
        return $this;
    }
    /**
     * Get extensionsInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo|null
     */
    public function getExtensionsInfo()
    {
        return $this->extensionsInfo;
    }
    /**
     * Set extensionsInfo value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setExtensionsInfo(\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo = null)
    {
        $this->extensionsInfo = $extensionsInfo;
        return $this;
    }
    /**
     * Get selfService value
     * @return string|null
     */
    public function getSelfService()
    {
        return $this->selfService;
    }
    /**
     * Set selfService value
     * @param string $selfService
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setSelfService($selfService = null)
    {
        // validation for constraint: string
        if (!is_null($selfService) && !is_string($selfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selfService, true), gettype($selfService)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($selfService) && mb_strlen($selfService) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($selfService)), __LINE__);
        }
        $this->selfService = $selfService;
        return $this;
    }
    /**
     * Get userProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUserProfile()
    {
        return $this->userProfile;
    }
    /**
     * Set userProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setUserProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null)
    {
        $this->userProfile = $userProfile;
        return $this;
    }
    /**
     * Get calendarPresence value
     * @return string|null
     */
    public function getCalendarPresence()
    {
        return $this->calendarPresence;
    }
    /**
     * Set calendarPresence value
     * @param string $calendarPresence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setCalendarPresence($calendarPresence = null)
    {
        // validation for constraint: string
        if (!is_null($calendarPresence) && !is_string($calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calendarPresence, true), gettype($calendarPresence)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($calendarPresence) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($calendarPresence, true)), __LINE__);
        }
        $this->calendarPresence = $calendarPresence;
        return $this;
    }
    /**
     * Get ldapDirectoryName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLdapDirectoryName()
    {
        return $this->ldapDirectoryName;
    }
    /**
     * Set ldapDirectoryName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setLdapDirectoryName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName = null)
    {
        $this->ldapDirectoryName = $ldapDirectoryName;
        return $this;
    }
    /**
     * Get userIdentity value
     * @return string|null
     */
    public function getUserIdentity()
    {
        return $this->userIdentity;
    }
    /**
     * Set userIdentity value
     * @param string $userIdentity
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setUserIdentity($userIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($userIdentity) && !is_string($userIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIdentity, true), gettype($userIdentity)), __LINE__);
        }
        $this->userIdentity = $userIdentity;
        return $this;
    }
    /**
     * Get nameDialing value
     * @return string|null
     */
    public function getNameDialing()
    {
        return $this->nameDialing;
    }
    /**
     * Set nameDialing value
     * @param string $nameDialing
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setNameDialing($nameDialing = null)
    {
        // validation for constraint: string
        if (!is_null($nameDialing) && !is_string($nameDialing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameDialing, true), gettype($nameDialing)), __LINE__);
        }
        $this->nameDialing = $nameDialing;
        return $this;
    }
    /**
     * Get ipccExtension value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getIpccExtension()
    {
        return $this->ipccExtension;
    }
    /**
     * Set ipccExtension value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setIpccExtension(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension = null)
    {
        $this->ipccExtension = $ipccExtension;
        return $this;
    }
    /**
     * Get convertUserAccount value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getConvertUserAccount()
    {
        return $this->convertUserAccount;
    }
    /**
     * Set convertUserAccount value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setConvertUserAccount(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount = null)
    {
        $this->convertUserAccount = $convertUserAccount;
        return $this;
    }
    /**
     * Get accountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType', is_array($accountType) ? implode(', ', $accountType) : var_export($accountType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAccountType::getValidValues())), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get authenticationType value
     * @return string|null
     */
    public function getAuthenticationType()
    {
        return $this->authenticationType;
    }
    /**
     * Set authenticationType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setAuthenticationType($authenticationType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::valueIsValid($authenticationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType', is_array($authenticationType) ? implode(', ', $authenticationType) : var_export($authenticationType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationType::getValidValues())), __LINE__);
        }
        $this->authenticationType = $authenticationType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
