<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRouteListMember StructType
 * @subpackage Structs
 */
class RRouteListMember extends AbstractStructBase
{
    /**
     * The routeGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeGroupName;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * The calledPartyTransformationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The dialPlanWizardGenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The prefixDigitsOut
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The useFullyQualifiedCallingPartyNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useFullyQualifiedCallingPartyNumber;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRouteListMember
     * @uses RRouteListMember::setRouteGroupName()
     * @uses RRouteListMember::setSelectionOrder()
     * @uses RRouteListMember::setCalledPartyTransformationMask()
     * @uses RRouteListMember::setCallingPartyTransformationMask()
     * @uses RRouteListMember::setDialPlanWizardGenId()
     * @uses RRouteListMember::setDigitDiscardInstructionName()
     * @uses RRouteListMember::setCallingPartyPrefixDigits()
     * @uses RRouteListMember::setPrefixDigitsOut()
     * @uses RRouteListMember::setUseFullyQualifiedCallingPartyNumber()
     * @uses RRouteListMember::setCallingPartyNumberingPlan()
     * @uses RRouteListMember::setCallingPartyNumberType()
     * @uses RRouteListMember::setCalledPartyNumberingPlan()
     * @uses RRouteListMember::setCalledPartyNumberType()
     * @uses RRouteListMember::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName
     * @param string $selectionOrder
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $dialPlanWizardGenId
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $callingPartyPrefixDigits
     * @param string $prefixDigitsOut
     * @param string $useFullyQualifiedCallingPartyNumber
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName = null, $selectionOrder = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $dialPlanWizardGenId = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $callingPartyPrefixDigits = null, $prefixDigitsOut = null, $useFullyQualifiedCallingPartyNumber = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, $uuid = null)
    {
        $this
            ->setRouteGroupName($routeGroupName)
            ->setSelectionOrder($selectionOrder)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setUuid($uuid);
    }
    /**
     * Get routeGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRouteGroupName()
    {
        return $this->routeGroupName;
    }
    /**
     * Set routeGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setRouteGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeGroupName = null)
    {
        $this->routeGroupName = $routeGroupName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyTransformationMask, true), gettype($calledPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($calledPartyTransformationMask) && mb_strlen($calledPartyTransformationMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($calledPartyTransformationMask)), __LINE__);
        }
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyTransformationMask, true), gettype($callingPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyTransformationMask) && mb_strlen($callingPartyTransformationMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dialPlanWizardGenId) ? implode(', ', $dialPlanWizardGenId) : var_export($dialPlanWizardGenId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setDigitDiscardInstructionName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callingPartyPrefixDigits, true), gettype($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callingPartyPrefixDigits) && mb_strlen($callingPartyPrefixDigits) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDigitsOut, true), gettype($prefixDigitsOut)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prefixDigitsOut) && mb_strlen($prefixDigitsOut) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get useFullyQualifiedCallingPartyNumber value
     * @return string|null
     */
    public function getUseFullyQualifiedCallingPartyNumber()
    {
        return $this->useFullyQualifiedCallingPartyNumber;
    }
    /**
     * Set useFullyQualifiedCallingPartyNumber value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useFullyQualifiedCallingPartyNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XStatus::valueIsValid($useFullyQualifiedCallingPartyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XStatus', is_array($useFullyQualifiedCallingPartyNumber) ? implode(', ', $useFullyQualifiedCallingPartyNumber) : var_export($useFullyQualifiedCallingPartyNumber, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useFullyQualifiedCallingPartyNumber = $useFullyQualifiedCallingPartyNumber;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($callingPartyNumberingPlan) ? implode(', ', $callingPartyNumberingPlan) : var_export($callingPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($callingPartyNumberType) ? implode(', ', $callingPartyNumberType) : var_export($callingPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan', is_array($calledPartyNumberingPlan) ? implode(', ', $calledPartyNumberingPlan) : var_export($calledPartyNumberingPlan, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber', is_array($calledPartyNumberType) ? implode(', ', $calledPartyNumberType) : var_export($calledPartyNumberType, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RRouteListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
