<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPresenceGroup StructType
 * @subpackage Structs
 */
class RPresenceGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The presenceGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\PresenceGroups
     */
    public $presenceGroups;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPresenceGroup
     * @uses RPresenceGroup::setName()
     * @uses RPresenceGroup::setDescription()
     * @uses RPresenceGroup::setPresenceGroups()
     * @uses RPresenceGroup::setUuid()
     * @param string $name
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PresenceGroups $presenceGroups
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\PresenceGroups $presenceGroups = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setPresenceGroups($presenceGroups)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPresenceGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPresenceGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get presenceGroups value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\PresenceGroups|null
     */
    public function getPresenceGroups()
    {
        return $this->presenceGroups;
    }
    /**
     * Set presenceGroups value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\PresenceGroups $presenceGroups
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPresenceGroup
     */
    public function setPresenceGroups(\Losc\CucmBundle\Model\Webservice\StructType\PresenceGroups $presenceGroups = null)
    {
        $this->presenceGroups = $presenceGroups;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RPresenceGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
