<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMohAudioSource StructType
 * @subpackage Structs
 */
class RMohAudioSource extends AbstractStructBase
{
    /**
     * The sourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sourceId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The sourceFile
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sourceFile;
    /**
     * The multicast
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The mohFileStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mohFileStatus;
    /**
     * The initialAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $initialAnnouncement;
    /**
     * The periodicAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $periodicAnnouncement;
    /**
     * The periodicAnnouncementInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $periodicAnnouncementInterval;
    /**
     * The localeAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $localeAnnouncement;
    /**
     * The initialAnnouncementPlayed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $initialAnnouncementPlayed;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMohAudioSource
     * @uses RMohAudioSource::setSourceId()
     * @uses RMohAudioSource::setName()
     * @uses RMohAudioSource::setSourceFile()
     * @uses RMohAudioSource::setMulticast()
     * @uses RMohAudioSource::setMohFileStatus()
     * @uses RMohAudioSource::setInitialAnnouncement()
     * @uses RMohAudioSource::setPeriodicAnnouncement()
     * @uses RMohAudioSource::setPeriodicAnnouncementInterval()
     * @uses RMohAudioSource::setLocaleAnnouncement()
     * @uses RMohAudioSource::setInitialAnnouncementPlayed()
     * @uses RMohAudioSource::setUuid()
     * @param string $sourceId
     * @param string $name
     * @param string $sourceFile
     * @param string $multicast
     * @param string $mohFileStatus
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @param string $periodicAnnouncementInterval
     * @param string $localeAnnouncement
     * @param string $initialAnnouncementPlayed
     * @param string $uuid
     */
    public function __construct($sourceId = null, $name = null, $sourceFile = null, $multicast = null, $mohFileStatus = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null, $periodicAnnouncementInterval = null, $localeAnnouncement = null, $initialAnnouncementPlayed = null, $uuid = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setName($name)
            ->setSourceFile($sourceFile)
            ->setMulticast($multicast)
            ->setMohFileStatus($mohFileStatus)
            ->setInitialAnnouncement($initialAnnouncement)
            ->setPeriodicAnnouncement($periodicAnnouncement)
            ->setPeriodicAnnouncementInterval($periodicAnnouncementInterval)
            ->setLocaleAnnouncement($localeAnnouncement)
            ->setInitialAnnouncementPlayed($initialAnnouncementPlayed)
            ->setUuid($uuid);
    }
    /**
     * Get sourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::valueIsValid($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId', is_array($sourceId) ? implode(', ', $sourceId) : var_export($sourceId, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->sourceFile;
    }
    /**
     * Set sourceFile value
     * @param string $sourceFile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setSourceFile($sourceFile = null)
    {
        // validation for constraint: string
        if (!is_null($sourceFile) && !is_string($sourceFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceFile, true), gettype($sourceFile)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($sourceFile) && mb_strlen($sourceFile) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($sourceFile)), __LINE__);
        }
        $this->sourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multicast, true), gettype($multicast)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($multicast, true)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get mohFileStatus value
     * @return string|null
     */
    public function getMohFileStatus()
    {
        return $this->mohFileStatus;
    }
    /**
     * Set mohFileStatus value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mohFileStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setMohFileStatus($mohFileStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($mohFileStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($mohFileStatus) ? implode(', ', $mohFileStatus) : var_export($mohFileStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mohFileStatus = $mohFileStatus;
        return $this;
    }
    /**
     * Get initialAnnouncement value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInitialAnnouncement()
    {
        return $this->initialAnnouncement;
    }
    /**
     * Set initialAnnouncement value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setInitialAnnouncement(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null)
    {
        $this->initialAnnouncement = $initialAnnouncement;
        return $this;
    }
    /**
     * Get periodicAnnouncement value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPeriodicAnnouncement()
    {
        return $this->periodicAnnouncement;
    }
    /**
     * Set periodicAnnouncement value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setPeriodicAnnouncement(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null)
    {
        $this->periodicAnnouncement = $periodicAnnouncement;
        return $this;
    }
    /**
     * Get periodicAnnouncementInterval value
     * @return string|null
     */
    public function getPeriodicAnnouncementInterval()
    {
        return $this->periodicAnnouncementInterval;
    }
    /**
     * Set periodicAnnouncementInterval value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicAnnouncementInterval
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setPeriodicAnnouncementInterval($periodicAnnouncementInterval = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($periodicAnnouncementInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($periodicAnnouncementInterval) ? implode(', ', $periodicAnnouncementInterval) : var_export($periodicAnnouncementInterval, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->periodicAnnouncementInterval = $periodicAnnouncementInterval;
        return $this;
    }
    /**
     * Get localeAnnouncement value
     * @return string|null
     */
    public function getLocaleAnnouncement()
    {
        return $this->localeAnnouncement;
    }
    /**
     * Set localeAnnouncement value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $localeAnnouncement
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setLocaleAnnouncement($localeAnnouncement = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::valueIsValid($localeAnnouncement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale', is_array($localeAnnouncement) ? implode(', ', $localeAnnouncement) : var_export($localeAnnouncement, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->localeAnnouncement = $localeAnnouncement;
        return $this;
    }
    /**
     * Get initialAnnouncementPlayed value
     * @return string|null
     */
    public function getInitialAnnouncementPlayed()
    {
        return $this->initialAnnouncementPlayed;
    }
    /**
     * Set initialAnnouncementPlayed value
     * @param string $initialAnnouncementPlayed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setInitialAnnouncementPlayed($initialAnnouncementPlayed = null)
    {
        // validation for constraint: string
        if (!is_null($initialAnnouncementPlayed) && !is_string($initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialAnnouncementPlayed, true), gettype($initialAnnouncementPlayed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($initialAnnouncementPlayed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($initialAnnouncementPlayed, true)), __LINE__);
        }
        $this->initialAnnouncementPlayed = $initialAnnouncementPlayed;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMohAudioSource
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
