<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RMediaResourceList StructType
 * @subpackage Structs
 */
class RMediaResourceList extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The clause
     * Meta information extracted from the WSDL
     * - documentation: Read only
     * - base: xsd:string
     * - maxLength: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clause;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RMediaResourceList
     * @uses RMediaResourceList::setName()
     * @uses RMediaResourceList::setClause()
     * @uses RMediaResourceList::setMembers()
     * @uses RMediaResourceList::setUuid()
     * @param string $name
     * @param string $clause
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $clause = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setClause($clause)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMediaResourceList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get clause value
     * @return string|null
     */
    public function getClause()
    {
        return $this->clause;
    }
    /**
     * Set clause value
     * @param string $clause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMediaResourceList
     */
    public function setClause($clause = null)
    {
        // validation for constraint: string
        if (!is_null($clause) && !is_string($clause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clause, true), gettype($clause)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($clause) && mb_strlen($clause) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($clause)), __LINE__);
        }
        $this->clause = $clause;
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMediaResourceList
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RMediaResourceList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
