<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLicensedUser StructType
 * @subpackage Structs
 */
class RLicensedUser extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The snrEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $snrEnabled;
    /**
     * The emEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $emEnabled;
    /**
     * The deviceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceCount;
    /**
     * The licenseType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $licenseType;
    /**
     * The licenseUsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $licenseUsed;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLicensedUser
     * @uses RLicensedUser::setUserId()
     * @uses RLicensedUser::setFirstName()
     * @uses RLicensedUser::setLastName()
     * @uses RLicensedUser::setSnrEnabled()
     * @uses RLicensedUser::setEmEnabled()
     * @uses RLicensedUser::setDeviceCount()
     * @uses RLicensedUser::setLicenseType()
     * @uses RLicensedUser::setLicenseUsed()
     * @uses RLicensedUser::setUuid()
     * @param string $userId
     * @param string $firstName
     * @param string $lastName
     * @param string $snrEnabled
     * @param string $emEnabled
     * @param string $deviceCount
     * @param string $licenseType
     * @param string $licenseUsed
     * @param string $uuid
     */
    public function __construct($userId = null, $firstName = null, $lastName = null, $snrEnabled = null, $emEnabled = null, $deviceCount = null, $licenseType = null, $licenseUsed = null, $uuid = null)
    {
        $this
            ->setUserId($userId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSnrEnabled($snrEnabled)
            ->setEmEnabled($emEnabled)
            ->setDeviceCount($deviceCount)
            ->setLicenseType($licenseType)
            ->setLicenseUsed($licenseUsed)
            ->setUuid($uuid);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get snrEnabled value
     * @return string|null
     */
    public function getSnrEnabled()
    {
        return $this->snrEnabled;
    }
    /**
     * Set snrEnabled value
     * @param string $snrEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setSnrEnabled($snrEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($snrEnabled) && !is_string($snrEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($snrEnabled, true), gettype($snrEnabled)), __LINE__);
        }
        $this->snrEnabled = $snrEnabled;
        return $this;
    }
    /**
     * Get emEnabled value
     * @return string|null
     */
    public function getEmEnabled()
    {
        return $this->emEnabled;
    }
    /**
     * Set emEnabled value
     * @param string $emEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setEmEnabled($emEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($emEnabled) && !is_string($emEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emEnabled, true), gettype($emEnabled)), __LINE__);
        }
        $this->emEnabled = $emEnabled;
        return $this;
    }
    /**
     * Get deviceCount value
     * @return string|null
     */
    public function getDeviceCount()
    {
        return $this->deviceCount;
    }
    /**
     * Set deviceCount value
     * @param string $deviceCount
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setDeviceCount($deviceCount = null)
    {
        // validation for constraint: string
        if (!is_null($deviceCount) && !is_string($deviceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceCount, true), gettype($deviceCount)), __LINE__);
        }
        $this->deviceCount = $deviceCount;
        return $this;
    }
    /**
     * Get licenseType value
     * @return string|null
     */
    public function getLicenseType()
    {
        return $this->licenseType;
    }
    /**
     * Set licenseType value
     * @param string $licenseType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setLicenseType($licenseType = null)
    {
        // validation for constraint: string
        if (!is_null($licenseType) && !is_string($licenseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseType, true), gettype($licenseType)), __LINE__);
        }
        $this->licenseType = $licenseType;
        return $this;
    }
    /**
     * Get licenseUsed value
     * @return string|null
     */
    public function getLicenseUsed()
    {
        return $this->licenseUsed;
    }
    /**
     * Set licenseUsed value
     * @param string $licenseUsed
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setLicenseUsed($licenseUsed = null)
    {
        // validation for constraint: string
        if (!is_null($licenseUsed) && !is_string($licenseUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseUsed, true), gettype($licenseUsed)), __LINE__);
        }
        $this->licenseUsed = $licenseUsed;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLicensedUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
