<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLdapSyncCustomField StructType
 * @subpackage Structs
 */
class RLdapSyncCustomField extends AbstractStructBase
{
    /**
     * The ldapConfigurationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapConfigurationName;
    /**
     * The customUserField
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customUserField;
    /**
     * The ldapUserField
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapUserField;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLdapSyncCustomField
     * @uses RLdapSyncCustomField::setLdapConfigurationName()
     * @uses RLdapSyncCustomField::setCustomUserField()
     * @uses RLdapSyncCustomField::setLdapUserField()
     * @uses RLdapSyncCustomField::setUuid()
     * @param string $ldapConfigurationName
     * @param string $customUserField
     * @param string $ldapUserField
     * @param string $uuid
     */
    public function __construct($ldapConfigurationName = null, $customUserField = null, $ldapUserField = null, $uuid = null)
    {
        $this
            ->setLdapConfigurationName($ldapConfigurationName)
            ->setCustomUserField($customUserField)
            ->setLdapUserField($ldapUserField)
            ->setUuid($uuid);
    }
    /**
     * Get ldapConfigurationName value
     * @return string|null
     */
    public function getLdapConfigurationName()
    {
        return $this->ldapConfigurationName;
    }
    /**
     * Set ldapConfigurationName value
     * @param string $ldapConfigurationName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField
     */
    public function setLdapConfigurationName($ldapConfigurationName = null)
    {
        // validation for constraint: string
        if (!is_null($ldapConfigurationName) && !is_string($ldapConfigurationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapConfigurationName, true), gettype($ldapConfigurationName)), __LINE__);
        }
        $this->ldapConfigurationName = $ldapConfigurationName;
        return $this;
    }
    /**
     * Get customUserField value
     * @return string|null
     */
    public function getCustomUserField()
    {
        return $this->customUserField;
    }
    /**
     * Set customUserField value
     * @param string $customUserField
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField
     */
    public function setCustomUserField($customUserField = null)
    {
        // validation for constraint: string
        if (!is_null($customUserField) && !is_string($customUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customUserField, true), gettype($customUserField)), __LINE__);
        }
        $this->customUserField = $customUserField;
        return $this;
    }
    /**
     * Get ldapUserField value
     * @return string|null
     */
    public function getLdapUserField()
    {
        return $this->ldapUserField;
    }
    /**
     * Set ldapUserField value
     * @param string $ldapUserField
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField
     */
    public function setLdapUserField($ldapUserField = null)
    {
        // validation for constraint: string
        if (!is_null($ldapUserField) && !is_string($ldapUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapUserField, true), gettype($ldapUserField)), __LINE__);
        }
        $this->ldapUserField = $ldapUserField;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RLdapSyncCustomField
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
