<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFallbackProfile StructType
 * @subpackage Structs
 */
class RFallbackProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The advertisedFallbackDirectoryE164Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $advertisedFallbackDirectoryE164Number;
    /**
     * The qosSensistivityLevel
     * Meta information extracted from the WSDL
     * - documentation: The Fallback QOS Sensitivity should be in range 1 to 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The callCss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callCss;
    /**
     * The callAnswerTimer
     * Meta information extracted from the WSDL
     * - documentation: The Fallback Call Answer Timer should be in range 1 to 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The directoryNumberPartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $directoryNumberPartition;
    /**
     * The directoryNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryNumber;
    /**
     * The numberOfDigitsForCallerIDPartialMatch
     * Meta information extracted from the WSDL
     * - documentation: The number of digits for Caller ID partial match should be in range 4 to 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfDigitsForCallerIDPartialMatch;
    /**
     * The numberOfCorrelationDtmfDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfCorrelationDtmfDigits;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RFallbackProfile
     * @uses RFallbackProfile::setName()
     * @uses RFallbackProfile::setDescription()
     * @uses RFallbackProfile::setAdvertisedFallbackDirectoryE164Number()
     * @uses RFallbackProfile::setQosSensistivityLevel()
     * @uses RFallbackProfile::setCallCss()
     * @uses RFallbackProfile::setCallAnswerTimer()
     * @uses RFallbackProfile::setDirectoryNumberPartition()
     * @uses RFallbackProfile::setDirectoryNumber()
     * @uses RFallbackProfile::setNumberOfDigitsForCallerIDPartialMatch()
     * @uses RFallbackProfile::setNumberOfCorrelationDtmfDigits()
     * @uses RFallbackProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $advertisedFallbackDirectoryE164Number
     * @param string $qosSensistivityLevel
     * @param string $callCss
     * @param string $callAnswerTimer
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition
     * @param string $directoryNumber
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @param string $numberOfCorrelationDtmfDigits
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $advertisedFallbackDirectoryE164Number = null, $qosSensistivityLevel = null, $callCss = null, $callAnswerTimer = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition = null, $directoryNumber = null, $numberOfDigitsForCallerIDPartialMatch = null, $numberOfCorrelationDtmfDigits = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setCallCss($callCss)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setDirectoryNumberPartition($directoryNumberPartition)
            ->setDirectoryNumber($directoryNumber)
            ->setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch)
            ->setNumberOfCorrelationDtmfDigits($numberOfCorrelationDtmfDigits)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get advertisedFallbackDirectoryE164Number value
     * @return string|null
     */
    public function getAdvertisedFallbackDirectoryE164Number()
    {
        return $this->advertisedFallbackDirectoryE164Number;
    }
    /**
     * Set advertisedFallbackDirectoryE164Number value
     * @param string $advertisedFallbackDirectoryE164Number
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number = null)
    {
        // validation for constraint: string
        if (!is_null($advertisedFallbackDirectoryE164Number) && !is_string($advertisedFallbackDirectoryE164Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertisedFallbackDirectoryE164Number, true), gettype($advertisedFallbackDirectoryE164Number)), __LINE__);
        }
        $this->advertisedFallbackDirectoryE164Number = $advertisedFallbackDirectoryE164Number;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($qosSensistivityLevel) ? implode(', ', $qosSensistivityLevel) : var_export($qosSensistivityLevel, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get callCss value
     * @return string|null
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XFallBackCSSSelection::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XFallBackCSSSelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setCallCss($callCss = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XFallBackCSSSelection::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XFallBackCSSSelection', is_array($callCss) ? implode(', ', $callCss) : var_export($callCss, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XFallBackCSSSelection::getValidValues())), __LINE__);
        }
        $this->callCss = $callCss;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setCallAnswerTimer($callAnswerTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($callAnswerTimer) ? implode(', ', $callAnswerTimer) : var_export($callAnswerTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get directoryNumberPartition value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDirectoryNumberPartition()
    {
        return $this->directoryNumberPartition;
    }
    /**
     * Set directoryNumberPartition value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setDirectoryNumberPartition(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $directoryNumberPartition = null)
    {
        $this->directoryNumberPartition = $directoryNumberPartition;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return string|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($directoryNumber) && !is_string($directoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryNumber, true), gettype($directoryNumber)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($directoryNumber) && mb_strlen($directoryNumber) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($directoryNumber)), __LINE__);
        }
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get numberOfDigitsForCallerIDPartialMatch value
     * @return string|null
     */
    public function getNumberOfDigitsForCallerIDPartialMatch()
    {
        return $this->numberOfDigitsForCallerIDPartialMatch;
    }
    /**
     * Set numberOfDigitsForCallerIDPartialMatch value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($numberOfDigitsForCallerIDPartialMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($numberOfDigitsForCallerIDPartialMatch) ? implode(', ', $numberOfDigitsForCallerIDPartialMatch) : var_export($numberOfDigitsForCallerIDPartialMatch, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigitsForCallerIDPartialMatch = $numberOfDigitsForCallerIDPartialMatch;
        return $this;
    }
    /**
     * Get numberOfCorrelationDtmfDigits value
     * @return string|null
     */
    public function getNumberOfCorrelationDtmfDigits()
    {
        return $this->numberOfCorrelationDtmfDigits;
    }
    /**
     * Set numberOfCorrelationDtmfDigits value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfCorrelationDtmfDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setNumberOfCorrelationDtmfDigits($numberOfCorrelationDtmfDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($numberOfCorrelationDtmfDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($numberOfCorrelationDtmfDigits) ? implode(', ', $numberOfCorrelationDtmfDigits) : var_export($numberOfCorrelationDtmfDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfCorrelationDtmfDigits = $numberOfCorrelationDtmfDigits;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
