<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFallbackFeatureConfig StructType
 * @subpackage Structs
 */
class RFallbackFeatureConfig extends AbstractStructBase
{
    /**
     * The enableFallbackForImeCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableFallbackForImeCalls;
    /**
     * The qosSensistivityLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The dtmfCorrelationDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dtmfCorrelationDigits;
    /**
     * The dtmfCollectionTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dtmfCollectionTimer;
    /**
     * The callAnswerTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The clearImeCallDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clearImeCallDelayTimer;
    /**
     * The dtmfInterDigitDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dtmfInterDigitDelayTimer;
    /**
     * The postConnectFallbackDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postConnectFallbackDelayTimer;
    /**
     * The fallbackSplitDelayTimer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fallbackSplitDelayTimer;
    /**
     * The callCss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callCss;
    /**
     * Constructor method for RFallbackFeatureConfig
     * @uses RFallbackFeatureConfig::setEnableFallbackForImeCalls()
     * @uses RFallbackFeatureConfig::setQosSensistivityLevel()
     * @uses RFallbackFeatureConfig::setDtmfCorrelationDigits()
     * @uses RFallbackFeatureConfig::setDtmfCollectionTimer()
     * @uses RFallbackFeatureConfig::setCallAnswerTimer()
     * @uses RFallbackFeatureConfig::setClearImeCallDelayTimer()
     * @uses RFallbackFeatureConfig::setDtmfInterDigitDelayTimer()
     * @uses RFallbackFeatureConfig::setPostConnectFallbackDelayTimer()
     * @uses RFallbackFeatureConfig::setFallbackSplitDelayTimer()
     * @uses RFallbackFeatureConfig::setCallCss()
     * @param string $enableFallbackForImeCalls
     * @param string $qosSensistivityLevel
     * @param string $dtmfCorrelationDigits
     * @param string $dtmfCollectionTimer
     * @param string $callAnswerTimer
     * @param string $clearImeCallDelayTimer
     * @param string $dtmfInterDigitDelayTimer
     * @param string $postConnectFallbackDelayTimer
     * @param string $fallbackSplitDelayTimer
     * @param string $callCss
     */
    public function __construct($enableFallbackForImeCalls = null, $qosSensistivityLevel = null, $dtmfCorrelationDigits = null, $dtmfCollectionTimer = null, $callAnswerTimer = null, $clearImeCallDelayTimer = null, $dtmfInterDigitDelayTimer = null, $postConnectFallbackDelayTimer = null, $fallbackSplitDelayTimer = null, $callCss = null)
    {
        $this
            ->setEnableFallbackForImeCalls($enableFallbackForImeCalls)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setDtmfCorrelationDigits($dtmfCorrelationDigits)
            ->setDtmfCollectionTimer($dtmfCollectionTimer)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setClearImeCallDelayTimer($clearImeCallDelayTimer)
            ->setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer)
            ->setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer)
            ->setFallbackSplitDelayTimer($fallbackSplitDelayTimer)
            ->setCallCss($callCss);
    }
    /**
     * Get enableFallbackForImeCalls value
     * @return string|null
     */
    public function getEnableFallbackForImeCalls()
    {
        return $this->enableFallbackForImeCalls;
    }
    /**
     * Set enableFallbackForImeCalls value
     * @param string $enableFallbackForImeCalls
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setEnableFallbackForImeCalls($enableFallbackForImeCalls = null)
    {
        // validation for constraint: string
        if (!is_null($enableFallbackForImeCalls) && !is_string($enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableFallbackForImeCalls, true), gettype($enableFallbackForImeCalls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableFallbackForImeCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableFallbackForImeCalls, true)), __LINE__);
        }
        $this->enableFallbackForImeCalls = $enableFallbackForImeCalls;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($qosSensistivityLevel) ? implode(', ', $qosSensistivityLevel) : var_export($qosSensistivityLevel, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get dtmfCorrelationDigits value
     * @return string|null
     */
    public function getDtmfCorrelationDigits()
    {
        return $this->dtmfCorrelationDigits;
    }
    /**
     * Set dtmfCorrelationDigits value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCorrelationDigits
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setDtmfCorrelationDigits($dtmfCorrelationDigits = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dtmfCorrelationDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dtmfCorrelationDigits) ? implode(', ', $dtmfCorrelationDigits) : var_export($dtmfCorrelationDigits, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dtmfCorrelationDigits = $dtmfCorrelationDigits;
        return $this;
    }
    /**
     * Get dtmfCollectionTimer value
     * @return string|null
     */
    public function getDtmfCollectionTimer()
    {
        return $this->dtmfCollectionTimer;
    }
    /**
     * Set dtmfCollectionTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCollectionTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setDtmfCollectionTimer($dtmfCollectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dtmfCollectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dtmfCollectionTimer) ? implode(', ', $dtmfCollectionTimer) : var_export($dtmfCollectionTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dtmfCollectionTimer = $dtmfCollectionTimer;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setCallAnswerTimer($callAnswerTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($callAnswerTimer) ? implode(', ', $callAnswerTimer) : var_export($callAnswerTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get clearImeCallDelayTimer value
     * @return string|null
     */
    public function getClearImeCallDelayTimer()
    {
        return $this->clearImeCallDelayTimer;
    }
    /**
     * Set clearImeCallDelayTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clearImeCallDelayTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setClearImeCallDelayTimer($clearImeCallDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($clearImeCallDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($clearImeCallDelayTimer) ? implode(', ', $clearImeCallDelayTimer) : var_export($clearImeCallDelayTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->clearImeCallDelayTimer = $clearImeCallDelayTimer;
        return $this;
    }
    /**
     * Get dtmfInterDigitDelayTimer value
     * @return string|null
     */
    public function getDtmfInterDigitDelayTimer()
    {
        return $this->dtmfInterDigitDelayTimer;
    }
    /**
     * Set dtmfInterDigitDelayTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfInterDigitDelayTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dtmfInterDigitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dtmfInterDigitDelayTimer) ? implode(', ', $dtmfInterDigitDelayTimer) : var_export($dtmfInterDigitDelayTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dtmfInterDigitDelayTimer = $dtmfInterDigitDelayTimer;
        return $this;
    }
    /**
     * Get postConnectFallbackDelayTimer value
     * @return string|null
     */
    public function getPostConnectFallbackDelayTimer()
    {
        return $this->postConnectFallbackDelayTimer;
    }
    /**
     * Set postConnectFallbackDelayTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postConnectFallbackDelayTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($postConnectFallbackDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($postConnectFallbackDelayTimer) ? implode(', ', $postConnectFallbackDelayTimer) : var_export($postConnectFallbackDelayTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->postConnectFallbackDelayTimer = $postConnectFallbackDelayTimer;
        return $this;
    }
    /**
     * Get fallbackSplitDelayTimer value
     * @return string|null
     */
    public function getFallbackSplitDelayTimer()
    {
        return $this->fallbackSplitDelayTimer;
    }
    /**
     * Set fallbackSplitDelayTimer value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fallbackSplitDelayTimer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setFallbackSplitDelayTimer($fallbackSplitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($fallbackSplitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($fallbackSplitDelayTimer) ? implode(', ', $fallbackSplitDelayTimer) : var_export($fallbackSplitDelayTimer, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->fallbackSplitDelayTimer = $fallbackSplitDelayTimer;
        return $this;
    }
    /**
     * Get callCss value
     * @return string|null
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RFallbackFeatureConfig
     */
    public function setCallCss($callCss = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($callCss) ? implode(', ', $callCss) : var_export($callCss, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callCss = $callCss;
        return $this;
    }
}
