<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for REmccFeatureConfig StructType
 * @subpackage Structs
 */
class REmccFeatureConfig extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: Name of the Emcc Parameter
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameterName;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for REmccFeatureConfig
     * @uses REmccFeatureConfig::setParameterName()
     * @uses REmccFeatureConfig::setValue()
     * @uses REmccFeatureConfig::setUuid()
     * @param string $parameterName
     * @param string $value
     * @param string $uuid
     */
    public function __construct($parameterName = null, $value = null, $uuid = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setValue($value)
            ->setUuid($uuid);
    }
    /**
     * Get parameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\REmccFeatureConfig
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parameterName) && mb_strlen($parameterName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parameterName)), __LINE__);
        }
        $this->parameterName = $parameterName;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\REmccFeatureConfig
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($value) && mb_strlen($value) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\REmccFeatureConfig
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
