<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDigitDiscardInstructionMember StructType
 * @subpackage Structs
 */
class RDigitDiscardInstructionMember extends AbstractStructBase
{
    /**
     * The dialPlanTagName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanTagName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDigitDiscardInstructionMember
     * @uses RDigitDiscardInstructionMember::setDialPlanTagName()
     * @uses RDigitDiscardInstructionMember::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName = null, $uuid = null)
    {
        $this
            ->setDialPlanTagName($dialPlanTagName)
            ->setUuid($uuid);
    }
    /**
     * Get dialPlanTagName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanTagName()
    {
        return $this->dialPlanTagName;
    }
    /**
     * Set dialPlanTagName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RDigitDiscardInstructionMember
     */
    public function setDialPlanTagName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanTagName = null)
    {
        $this->dialPlanTagName = $dialPlanTagName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RDigitDiscardInstructionMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
