<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCommunityString StructType
 * @subpackage Structs
 */
class RCommunityString extends AbstractStructBase
{
    /**
     * The communityName
     * @var string
     */
    public $communityName;
    /**
     * The accessPrivilege
     * @var string
     */
    public $accessPrivilege;
    /**
     * The ArrayOfHosts
     * @var \Losc\CucmBundle\Model\Webservice\ArrayType\RArrayOfHosts
     */
    public $ArrayOfHosts;
    /**
     * Constructor method for RCommunityString
     * @uses RCommunityString::setCommunityName()
     * @uses RCommunityString::setAccessPrivilege()
     * @uses RCommunityString::setArrayOfHosts()
     * @param string $communityName
     * @param string $accessPrivilege
     * @param \Losc\CucmBundle\Model\Webservice\ArrayType\RArrayOfHosts $arrayOfHosts
     */
    public function __construct($communityName = null, $accessPrivilege = null, \Losc\CucmBundle\Model\Webservice\ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this
            ->setCommunityName($communityName)
            ->setAccessPrivilege($accessPrivilege)
            ->setArrayOfHosts($arrayOfHosts);
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCommunityString
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communityName, true), gettype($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
    /**
     * Get accessPrivilege value
     * @return string|null
     */
    public function getAccessPrivilege()
    {
        return $this->accessPrivilege;
    }
    /**
     * Set accessPrivilege value
     * @param string $accessPrivilege
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCommunityString
     */
    public function setAccessPrivilege($accessPrivilege = null)
    {
        // validation for constraint: string
        if (!is_null($accessPrivilege) && !is_string($accessPrivilege)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessPrivilege, true), gettype($accessPrivilege)), __LINE__);
        }
        $this->accessPrivilege = $accessPrivilege;
        return $this;
    }
    /**
     * Get ArrayOfHosts value
     * @return \Losc\CucmBundle\Model\Webservice\ArrayType\RArrayOfHosts|null
     */
    public function getArrayOfHosts()
    {
        return $this->ArrayOfHosts;
    }
    /**
     * Set ArrayOfHosts value
     * @param \Losc\CucmBundle\Model\Webservice\ArrayType\RArrayOfHosts $arrayOfHosts
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCommunityString
     */
    public function setArrayOfHosts(\Losc\CucmBundle\Model\Webservice\ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this->ArrayOfHosts = $arrayOfHosts;
        return $this;
    }
}
