<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcmExternalIpMap StructType
 * @subpackage Structs
 */
class RCcmExternalIpMap extends AbstractStructBase
{
    /**
     * The callManagerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callManagerName;
    /**
     * The ipAddressHost
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressHost;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcmExternalIpMap
     * @uses RCcmExternalIpMap::setCallManagerName()
     * @uses RCcmExternalIpMap::setIpAddressHost()
     * @uses RCcmExternalIpMap::setPort()
     * @uses RCcmExternalIpMap::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerName
     * @param string $ipAddressHost
     * @param string $port
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerName = null, $ipAddressHost = null, $port = null, $uuid = null)
    {
        $this
            ->setCallManagerName($callManagerName)
            ->setIpAddressHost($ipAddressHost)
            ->setPort($port)
            ->setUuid($uuid);
    }
    /**
     * Get callManagerName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallManagerName()
    {
        return $this->callManagerName;
    }
    /**
     * Set callManagerName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcmExternalIpMap
     */
    public function setCallManagerName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerName = null)
    {
        $this->callManagerName = $callManagerName;
        return $this;
    }
    /**
     * Get ipAddressHost value
     * @return string|null
     */
    public function getIpAddressHost()
    {
        return $this->ipAddressHost;
    }
    /**
     * Set ipAddressHost value
     * @param string $ipAddressHost
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcmExternalIpMap
     */
    public function setIpAddressHost($ipAddressHost = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddressHost) && !is_string($ipAddressHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddressHost, true), gettype($ipAddressHost)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($ipAddressHost) && mb_strlen($ipAddressHost) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($ipAddressHost)), __LINE__);
        }
        $this->ipAddressHost = $ipAddressHost;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcmExternalIpMap
     */
    public function setPort($port = null)
    {
        // validation for constraint: string
        if (!is_null($port) && !is_string($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($port, true), gettype($port)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($port) && mb_strlen($port) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($port)), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCcmExternalIpMap
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
