<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallerFilterListMember StructType
 * @subpackage Structs
 */
class RCallerFilterListMember extends AbstractStructBase
{
    /**
     * The DnMask
     * Meta information extracted from the WSDL
     * - documentation: Mandatory when "callerFilterMask" has value as Directory Number
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DnMask;
    /**
     * The callerFilterMask
     * Meta information extracted from the WSDL
     * - documentation: Mandatory when value is a directory number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerFilterMask;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallerFilterListMember
     * @uses RCallerFilterListMember::setDnMask()
     * @uses RCallerFilterListMember::setCallerFilterMask()
     * @uses RCallerFilterListMember::setUuid()
     * @param string $dnMask
     * @param string $callerFilterMask
     * @param string $uuid
     */
    public function __construct($dnMask = null, $callerFilterMask = null, $uuid = null)
    {
        $this
            ->setDnMask($dnMask)
            ->setCallerFilterMask($callerFilterMask)
            ->setUuid($uuid);
    }
    /**
     * Get DnMask value
     * @return string|null
     */
    public function getDnMask()
    {
        return $this->DnMask;
    }
    /**
     * Set DnMask value
     * @param string $dnMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCallerFilterListMember
     */
    public function setDnMask($dnMask = null)
    {
        // validation for constraint: string
        if (!is_null($dnMask) && !is_string($dnMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dnMask, true), gettype($dnMask)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($dnMask) && mb_strlen($dnMask) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($dnMask)), __LINE__);
        }
        $this->DnMask = $dnMask;
        return $this;
    }
    /**
     * Get callerFilterMask value
     * @return string|null
     */
    public function getCallerFilterMask()
    {
        return $this->callerFilterMask;
    }
    /**
     * Set callerFilterMask value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerFilterMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCallerFilterListMember
     */
    public function setCallerFilterMask($callerFilterMask = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::valueIsValid($callerFilterMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask', is_array($callerFilterMask) ? implode(', ', $callerFilterMask) : var_export($callerFilterMask, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCallerFilterMask::getValidValues())), __LINE__);
        }
        $this->callerFilterMask = $callerFilterMask;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RCallerFilterListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
