<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RApplicationUserCapfProfile StructType
 * @subpackage Structs
 */
class RApplicationUserCapfProfile extends AbstractStructBase
{
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $applicationUser;
    /**
     * The instanceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $instanceId;
    /**
     * The certificateOperation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The operationCompletion
     * Meta information extracted from the WSDL
     * - documentation: Required format is YYYY:MM:DD:HH:SS. Read Only when certificateOperation is 'No Pending Operation'. Please provide the above format while adding a new device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operationCompletion;
    /**
     * The certificationOperationStatus
     * Meta information extracted from the WSDL
     * - documentation: Read-Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificationOperationStatus;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RApplicationUserCapfProfile
     * @uses RApplicationUserCapfProfile::setApplicationUser()
     * @uses RApplicationUserCapfProfile::setInstanceId()
     * @uses RApplicationUserCapfProfile::setCertificateOperation()
     * @uses RApplicationUserCapfProfile::setAuthenticationMode()
     * @uses RApplicationUserCapfProfile::setAuthenticationString()
     * @uses RApplicationUserCapfProfile::setKeySize()
     * @uses RApplicationUserCapfProfile::setOperationCompletion()
     * @uses RApplicationUserCapfProfile::setCertificationOperationStatus()
     * @uses RApplicationUserCapfProfile::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @param string $instanceId
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $operationCompletion
     * @param string $certificationOperationStatus
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null, $instanceId = null, $certificateOperation = null, $authenticationMode = null, $authenticationString = null, $keySize = null, $operationCompletion = null, $certificationOperationStatus = null, $uuid = null)
    {
        $this
            ->setApplicationUser($applicationUser)
            ->setInstanceId($instanceId)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setOperationCompletion($operationCompletion)
            ->setCertificationOperationStatus($certificationOperationStatus)
            ->setUuid($uuid);
    }
    /**
     * Get applicationUser value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setApplicationUser(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get instanceId value
     * @return string|null
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceId, true), gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setCertificateOperation($certificateOperation = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation', is_array($certificateOperation) ? implode(', ', $certificateOperation) : var_export($certificateOperation, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode', is_array($authenticationMode) ? implode(', ', $authenticationMode) : var_export($authenticationMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationString, true), gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize', is_array($keySize) ? implode(', ', $keySize) : var_export($keySize, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationCompletion, true), gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
    /**
     * Get certificationOperationStatus value
     * @return string|null
     */
    public function getCertificationOperationStatus()
    {
        return $this->certificationOperationStatus;
    }
    /**
     * Set certificationOperationStatus value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateStatus::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificationOperationStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setCertificationOperationStatus($certificationOperationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XCertificateStatus::valueIsValid($certificationOperationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateStatus', is_array($certificationOperationStatus) ? implode(', ', $certificationOperationStatus) : var_export($certificationOperationStatus, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XCertificateStatus::getValidValues())), __LINE__);
        }
        $this->certificationOperationStatus = $certificationOperationStatus;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RApplicationUserCapfProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
