<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAarGroup StructType
 * @subpackage Structs
 */
class RAarGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The relatedGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\RelatedGroups
     */
    public $relatedGroups;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAarGroup
     * @uses RAarGroup::setName()
     * @uses RAarGroup::setRelatedGroups()
     * @uses RAarGroup::setUuid()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RelatedGroups $relatedGroups
     * @param string $uuid
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\RelatedGroups $relatedGroups = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setRelatedGroups($relatedGroups)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAarGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($name) && mb_strlen($name) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get relatedGroups value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RelatedGroups|null
     */
    public function getRelatedGroups()
    {
        return $this->relatedGroups;
    }
    /**
     * Set relatedGroups value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\RelatedGroups $relatedGroups
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAarGroup
     */
    public function setRelatedGroups(\Losc\CucmBundle\Model\Webservice\StructType\RelatedGroups $relatedGroups = null)
    {
        $this->relatedGroups = $relatedGroups;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\RAarGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
