<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXTransPattern StructType
 * @subpackage Structs
 */
class OXTransPattern extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $routePartitionName;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $patternPrecedence;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $releaseClause;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXTransPattern
     * @uses OXTransPattern::setUsage()
     * @uses OXTransPattern::setRoutePartitionName()
     * @uses OXTransPattern::setUseCallingPartyPhoneMask()
     * @uses OXTransPattern::setDialPlanName()
     * @uses OXTransPattern::setDigitDiscardInstructionName()
     * @uses OXTransPattern::setRouteFilterName()
     * @uses OXTransPattern::setCallingLinePresentationBit()
     * @uses OXTransPattern::setCallingNamePresentationBit()
     * @uses OXTransPattern::setConnectedLinePresentationBit()
     * @uses OXTransPattern::setConnectedNamePresentationBit()
     * @uses OXTransPattern::setPatternPrecedence()
     * @uses OXTransPattern::setCallingPartyNumberingPlan()
     * @uses OXTransPattern::setCallingPartyNumberType()
     * @uses OXTransPattern::setCalledPartyNumberingPlan()
     * @uses OXTransPattern::setCalledPartyNumberType()
     * @uses OXTransPattern::setCallingSearchSpaceName()
     * @uses OXTransPattern::setResourcePriorityNamespaceName()
     * @uses OXTransPattern::setRouteClass()
     * @uses OXTransPattern::setCallInterceptProfileName()
     * @uses OXTransPattern::setReleaseClause()
     * @uses OXTransPattern::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $usage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routePartitionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useCallingPartyPhoneMask
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialPlanName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $digitDiscardInstructionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeFilterName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLinePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingNamePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedLinePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedNamePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $patternPrecedence
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberingPlan
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberType
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberingPlan
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberType
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeClass
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInterceptProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $releaseClause
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $usage = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routePartitionName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useCallingPartyPhoneMask = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialPlanName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $digitDiscardInstructionName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeFilterName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLinePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingNamePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedLinePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedNamePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $patternPrecedence = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberingPlan = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberType = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberingPlan = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberType = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeClass = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInterceptProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $releaseClause = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setUsage(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useCallingPartyPhoneMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setUseCallingPartyPhoneMask(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialPlanName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setDialPlanName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $digitDiscardInstructionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setDigitDiscardInstructionName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setRouteFilterName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCallingLinePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCallingNamePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setConnectedLinePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setConnectedNamePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setPatternPrecedence(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCallingPartyNumberingPlan(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCallingPartyNumberType(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCalledPartyNumberingPlan(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCalledPartyNumberType(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setResourcePriorityNamespaceName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeClass
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setRouteClass(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInterceptProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setCallInterceptProfileName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $releaseClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setReleaseClause(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXTransPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
