<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXSipProfile StructType
 * @subpackage Structs
 */
class OXSipProfile extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $telnetLevel;
    /**
     * The rerouteIncomingRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The rsvpOverSip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $rsvpOverSip;
    /**
     * The sipRe11XxEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $gClear;
    /**
     * The sipBandwidthModifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $sipBandwidthModifier;
    /**
     * The userAgentServerHeaderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $userAgentServerHeaderInfo;
    /**
     * The sipNormalizationScript
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $sipNormalizationScript;
    /**
     * The dialStringInterpretation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $acceptAudioCodecPreferences;
    /**
     * The resourcePriorityNamespace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The callingLineIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $callingLineIdentification;
    /**
     * The videoCallTrafficClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta information extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $sdpTransparency;
    /**
     * The sipSessionRefreshMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\OXFkType
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXSipProfile
     * @uses OXSipProfile::setUserInfo()
     * @uses OXSipProfile::setDtmfDbLevel()
     * @uses OXSipProfile::setCallHoldRingback()
     * @uses OXSipProfile::setAnonymousCallBlock()
     * @uses OXSipProfile::setCallerIdBlock()
     * @uses OXSipProfile::setDndControl()
     * @uses OXSipProfile::setTelnetLevel()
     * @uses OXSipProfile::setRerouteIncomingRequest()
     * @uses OXSipProfile::setResourcePriorityNamespaceListName()
     * @uses OXSipProfile::setRsvpOverSip()
     * @uses OXSipProfile::setSipRe11XxEnabled()
     * @uses OXSipProfile::setGClear()
     * @uses OXSipProfile::setSipBandwidthModifier()
     * @uses OXSipProfile::setUserAgentServerHeaderInfo()
     * @uses OXSipProfile::setSipNormalizationScript()
     * @uses OXSipProfile::setDialStringInterpretation()
     * @uses OXSipProfile::setAcceptAudioCodecPreferences()
     * @uses OXSipProfile::setResourcePriorityNamespace()
     * @uses OXSipProfile::setCallingLineIdentification()
     * @uses OXSipProfile::setVideoCallTrafficClass()
     * @uses OXSipProfile::setSdpTransparency()
     * @uses OXSipProfile::setSipSessionRefreshMethod()
     * @uses OXSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses OXSipProfile::setCucmVersionInSipHeader()
     * @uses OXSipProfile::setConfidentialAccessLevelHeaders()
     * @uses OXSipProfile::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userInfo
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dtmfDbLevel
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callHoldRingback
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $anonymousCallBlock
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callerIdBlock
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndControl
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $telnetLevel
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteIncomingRequest
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceListName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rsvpOverSip
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipRe11XxEnabled
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $gClear
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipBandwidthModifier
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userAgentServerHeaderInfo
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipNormalizationScript
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialStringInterpretation
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $acceptAudioCodecPreferences
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespace
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLineIdentification
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $videoCallTrafficClass
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sdpTransparency
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipSessionRefreshMethod
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $earlyOfferSuppVoiceCall
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cucmVersionInSipHeader
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $confidentialAccessLevelHeaders
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userInfo = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dtmfDbLevel = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callHoldRingback = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $anonymousCallBlock = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callerIdBlock = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndControl = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $telnetLevel = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteIncomingRequest = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceListName = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rsvpOverSip = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipRe11XxEnabled = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $gClear = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipBandwidthModifier = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userAgentServerHeaderInfo = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipNormalizationScript = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialStringInterpretation = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $acceptAudioCodecPreferences = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespace = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLineIdentification = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $videoCallTrafficClass = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sdpTransparency = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipSessionRefreshMethod = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $earlyOfferSuppVoiceCall = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cucmVersionInSipHeader = null, \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $confidentialAccessLevelHeaders = null, $uuid = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setRsvpOverSip($rsvpOverSip)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setUuid($uuid);
    }
    /**
     * Get userInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setUserInfo(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dtmfDbLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setDtmfDbLevel(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dtmfDbLevel = null)
    {
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callHoldRingback
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setCallHoldRingback(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callHoldRingback = null)
    {
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $anonymousCallBlock
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setAnonymousCallBlock(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $anonymousCallBlock = null)
    {
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callerIdBlock
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setCallerIdBlock(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callerIdBlock = null)
    {
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndControl
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setDndControl(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dndControl = null)
    {
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $telnetLevel
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setTelnetLevel(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $telnetLevel = null)
    {
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteIncomingRequest
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setRerouteIncomingRequest(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rerouteIncomingRequest = null)
    {
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceListName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setResourcePriorityNamespaceListName(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rsvpOverSip
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setRsvpOverSip(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $rsvpOverSip = null)
    {
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipRe11XxEnabled
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setSipRe11XxEnabled(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipRe11XxEnabled = null)
    {
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $gClear
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setGClear(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $gClear = null)
    {
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipBandwidthModifier
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setSipBandwidthModifier(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipBandwidthModifier = null)
    {
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userAgentServerHeaderInfo
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setUserAgentServerHeaderInfo(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $userAgentServerHeaderInfo = null)
    {
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipNormalizationScript
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setSipNormalizationScript(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialStringInterpretation
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setDialStringInterpretation(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $dialStringInterpretation = null)
    {
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $acceptAudioCodecPreferences
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setAcceptAudioCodecPreferences(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $acceptAudioCodecPreferences = null)
    {
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespace
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setResourcePriorityNamespace(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLineIdentification
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setCallingLineIdentification(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $callingLineIdentification = null)
    {
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $videoCallTrafficClass
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setVideoCallTrafficClass(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $videoCallTrafficClass = null)
    {
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sdpTransparency
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setSdpTransparency(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipSessionRefreshMethod
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setSipSessionRefreshMethod(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $sipSessionRefreshMethod = null)
    {
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $earlyOfferSuppVoiceCall
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setEarlyOfferSuppVoiceCall(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $earlyOfferSuppVoiceCall = null)
    {
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cucmVersionInSipHeader
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setCucmVersionInSipHeader(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $cucmVersionInSipHeader = null)
    {
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkType|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\OXFkType $confidentialAccessLevelHeaders
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setConfidentialAccessLevelHeaders(\Losc\CucmBundle\Model\Webservice\StructType\OXFkType $confidentialAccessLevelHeaders = null)
    {
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
