<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXFkTypeProduct StructType
 * @subpackage Structs
 */
class OXFkTypeProduct extends OXFkType
{
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * Constructor method for OXFkTypeProduct
     * @uses OXFkTypeProduct::setProduct()
     * @param string $product
     */
    public function __construct($product = null)
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
}
