<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORTransPattern StructType
 * @subpackage Structs
 */
class ORTransPattern extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $routePartitionName;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $patternPrecedence;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\ORFkType
     */
    public $releaseClause;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORTransPattern
     * @uses ORTransPattern::setUsage()
     * @uses ORTransPattern::setRoutePartitionName()
     * @uses ORTransPattern::setUseCallingPartyPhoneMask()
     * @uses ORTransPattern::setDialPlanName()
     * @uses ORTransPattern::setDigitDiscardInstructionName()
     * @uses ORTransPattern::setRouteFilterName()
     * @uses ORTransPattern::setCallingLinePresentationBit()
     * @uses ORTransPattern::setCallingNamePresentationBit()
     * @uses ORTransPattern::setConnectedLinePresentationBit()
     * @uses ORTransPattern::setConnectedNamePresentationBit()
     * @uses ORTransPattern::setPatternPrecedence()
     * @uses ORTransPattern::setCallingPartyNumberingPlan()
     * @uses ORTransPattern::setCallingPartyNumberType()
     * @uses ORTransPattern::setCalledPartyNumberingPlan()
     * @uses ORTransPattern::setCalledPartyNumberType()
     * @uses ORTransPattern::setCallingSearchSpaceName()
     * @uses ORTransPattern::setResourcePriorityNamespaceName()
     * @uses ORTransPattern::setRouteClass()
     * @uses ORTransPattern::setCallInterceptProfileName()
     * @uses ORTransPattern::setReleaseClause()
     * @uses ORTransPattern::setUuid()
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $useCallingPartyPhoneMask
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialPlanName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $digitDiscardInstructionName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeFilterName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLinePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingNamePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedLinePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedNamePresentationBit
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberingPlan
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberType
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberingPlan
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberType
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingSearchSpaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeClass
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callInterceptProfileName
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause
     * @param string $uuid
     */
    public function __construct(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $useCallingPartyPhoneMask = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialPlanName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $digitDiscardInstructionName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeFilterName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLinePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingNamePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedLinePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedNamePresentationBit = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberingPlan = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberType = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberingPlan = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberType = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingSearchSpaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeClass = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callInterceptProfileName = null, \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setUsage(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setRoutePartitionName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $useCallingPartyPhoneMask
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setUseCallingPartyPhoneMask(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialPlanName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setDialPlanName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $digitDiscardInstructionName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setDigitDiscardInstructionName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeFilterName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setRouteFilterName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCallingLinePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCallingNamePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedLinePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setConnectedLinePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedNamePresentationBit
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setConnectedNamePresentationBit(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setPatternPrecedence(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCallingPartyNumberingPlan(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCallingPartyNumberType(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberingPlan
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCalledPartyNumberingPlan(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberType
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCalledPartyNumberType(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingSearchSpaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCallingSearchSpaceName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setResourcePriorityNamespaceName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeClass
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setRouteClass(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callInterceptProfileName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setCallInterceptProfileName(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setReleaseClause(\Losc\CucmBundle\Model\Webservice\StructType\ORFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\ORTransPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
