<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewLLdapSyncCustomField StructType
 * @subpackage Structs
 */
class NewLLdapSyncCustomField extends AbstractStructBase
{
    /**
     * The ldapUserField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ldapUserField;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for NewLLdapSyncCustomField
     * @uses NewLLdapSyncCustomField::setLdapUserField()
     * @uses NewLLdapSyncCustomField::setUuid()
     * @param string $ldapUserField
     * @param string $uuid
     */
    public function __construct($ldapUserField = null, $uuid = null)
    {
        $this
            ->setLdapUserField($ldapUserField)
            ->setUuid($uuid);
    }
    /**
     * Get ldapUserField value
     * @return string|null
     */
    public function getLdapUserField()
    {
        return $this->ldapUserField;
    }
    /**
     * Set ldapUserField value
     * @param string $ldapUserField
     * @return \Losc\CucmBundle\Model\Webservice\StructType\NewLLdapSyncCustomField
     */
    public function setLdapUserField($ldapUserField = null)
    {
        // validation for constraint: string
        if (!is_null($ldapUserField) && !is_string($ldapUserField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapUserField, true), gettype($ldapUserField)), __LINE__);
        }
        $this->ldapUserField = $ldapUserField;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\NewLLdapSyncCustomField
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
