<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LUserProfileProvision StructType
 * @subpackage Structs
 */
class LUserProfileProvision extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The allowProvision
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowProvision;
    /**
     * The limitProvision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $limitProvision;
    /**
     * The defaultUserProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultUserProfile;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LUserProfileProvision
     * @uses LUserProfileProvision::setName()
     * @uses LUserProfileProvision::setDescription()
     * @uses LUserProfileProvision::setAllowProvision()
     * @uses LUserProfileProvision::setLimitProvision()
     * @uses LUserProfileProvision::setDefaultUserProfile()
     * @uses LUserProfileProvision::setUuid()
     * @param string $name
     * @param string $description
     * @param string $allowProvision
     * @param string $limitProvision
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultUserProfile
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $allowProvision = null, $limitProvision = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultUserProfile = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setAllowProvision($allowProvision)
            ->setLimitProvision($limitProvision)
            ->setDefaultUserProfile($defaultUserProfile)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LUserProfileProvision
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LUserProfileProvision
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get allowProvision value
     * @return string|null
     */
    public function getAllowProvision()
    {
        return $this->allowProvision;
    }
    /**
     * Set allowProvision value
     * @param string $allowProvision
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LUserProfileProvision
     */
    public function setAllowProvision($allowProvision = null)
    {
        // validation for constraint: string
        if (!is_null($allowProvision) && !is_string($allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowProvision, true), gettype($allowProvision)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowProvision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowProvision, true)), __LINE__);
        }
        $this->allowProvision = $allowProvision;
        return $this;
    }
    /**
     * Get limitProvision value
     * @return string|null
     */
    public function getLimitProvision()
    {
        return $this->limitProvision;
    }
    /**
     * Set limitProvision value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitProvision
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LUserProfileProvision
     */
    public function setLimitProvision($limitProvision = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($limitProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($limitProvision) ? implode(', ', $limitProvision) : var_export($limitProvision, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->limitProvision = $limitProvision;
        return $this;
    }
    /**
     * Get defaultUserProfile value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultUserProfile()
    {
        return $this->defaultUserProfile;
    }
    /**
     * Set defaultUserProfile value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultUserProfile
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LUserProfileProvision
     */
    public function setDefaultUserProfile(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultUserProfile = null)
    {
        $this->defaultUserProfile = $defaultUserProfile;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LUserProfileProvision
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
