<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipTrunkSecurityProfile StructType
 * @subpackage Structs
 */
class LSipTrunkSecurityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $securityMode;
    /**
     * The incomingTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $incomingTransport;
    /**
     * The outgoingTransport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outgoingTransport;
    /**
     * The digestAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $digestAuthentication;
    /**
     * The noncePolicyTime
     * Meta information extracted from the WSDL
     * - documentation: Only if digestAuthentication is enabled this value can be changed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $noncePolicyTime;
    /**
     * The x509SubjectName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4096
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $x509SubjectName;
    /**
     * The incomingPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $incomingPort;
    /**
     * The applLevelAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applLevelAuthentication;
    /**
     * The acceptPresenceSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The transmitSecurityStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitSecurityStatus;
    /**
     * The sipV150OutboundSdpOfferFiltering
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipV150OutboundSdpOfferFiltering;
    /**
     * The allowChargingHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowChargingHeader;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipTrunkSecurityProfile
     * @uses LSipTrunkSecurityProfile::setName()
     * @uses LSipTrunkSecurityProfile::setDescription()
     * @uses LSipTrunkSecurityProfile::setSecurityMode()
     * @uses LSipTrunkSecurityProfile::setIncomingTransport()
     * @uses LSipTrunkSecurityProfile::setOutgoingTransport()
     * @uses LSipTrunkSecurityProfile::setDigestAuthentication()
     * @uses LSipTrunkSecurityProfile::setNoncePolicyTime()
     * @uses LSipTrunkSecurityProfile::setX509SubjectName()
     * @uses LSipTrunkSecurityProfile::setIncomingPort()
     * @uses LSipTrunkSecurityProfile::setApplLevelAuthentication()
     * @uses LSipTrunkSecurityProfile::setAcceptPresenceSubscription()
     * @uses LSipTrunkSecurityProfile::setAcceptOutOfDialogRefer()
     * @uses LSipTrunkSecurityProfile::setAcceptUnsolicitedNotification()
     * @uses LSipTrunkSecurityProfile::setAllowReplaceHeader()
     * @uses LSipTrunkSecurityProfile::setTransmitSecurityStatus()
     * @uses LSipTrunkSecurityProfile::setSipV150OutboundSdpOfferFiltering()
     * @uses LSipTrunkSecurityProfile::setAllowChargingHeader()
     * @uses LSipTrunkSecurityProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $securityMode
     * @param string $incomingTransport
     * @param string $outgoingTransport
     * @param string $digestAuthentication
     * @param string $noncePolicyTime
     * @param string $x509SubjectName
     * @param string $incomingPort
     * @param string $applLevelAuthentication
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $transmitSecurityStatus
     * @param string $sipV150OutboundSdpOfferFiltering
     * @param string $allowChargingHeader
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $securityMode = null, $incomingTransport = null, $outgoingTransport = null, $digestAuthentication = null, $noncePolicyTime = null, $x509SubjectName = null, $incomingPort = null, $applLevelAuthentication = null, $acceptPresenceSubscription = null, $acceptOutOfDialogRefer = null, $acceptUnsolicitedNotification = null, $allowReplaceHeader = null, $transmitSecurityStatus = null, $sipV150OutboundSdpOfferFiltering = null, $allowChargingHeader = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setIncomingTransport($incomingTransport)
            ->setOutgoingTransport($outgoingTransport)
            ->setDigestAuthentication($digestAuthentication)
            ->setNoncePolicyTime($noncePolicyTime)
            ->setX509SubjectName($x509SubjectName)
            ->setIncomingPort($incomingPort)
            ->setApplLevelAuthentication($applLevelAuthentication)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setTransmitSecurityStatus($transmitSecurityStatus)
            ->setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering)
            ->setAllowChargingHeader($allowChargingHeader)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($description) && mb_strlen($description) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get securityMode value
     * @return string|null
     */
    public function getSecurityMode()
    {
        return $this->securityMode;
    }
    /**
     * Set securityMode value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode', is_array($securityMode) ? implode(', ', $securityMode) : var_export($securityMode, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        $this->securityMode = $securityMode;
        return $this;
    }
    /**
     * Get incomingTransport value
     * @return string|null
     */
    public function getIncomingTransport()
    {
        return $this->incomingTransport;
    }
    /**
     * Set incomingTransport value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingTransport
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setIncomingTransport($incomingTransport = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid($incomingTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTransport', is_array($incomingTransport) ? implode(', ', $incomingTransport) : var_export($incomingTransport, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->incomingTransport = $incomingTransport;
        return $this;
    }
    /**
     * Get outgoingTransport value
     * @return string|null
     */
    public function getOutgoingTransport()
    {
        return $this->outgoingTransport;
    }
    /**
     * Set outgoingTransport value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outgoingTransport
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setOutgoingTransport($outgoingTransport = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTransport::valueIsValid($outgoingTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTransport', is_array($outgoingTransport) ? implode(', ', $outgoingTransport) : var_export($outgoingTransport, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->outgoingTransport = $outgoingTransport;
        return $this;
    }
    /**
     * Get digestAuthentication value
     * @return string|null
     */
    public function getDigestAuthentication()
    {
        return $this->digestAuthentication;
    }
    /**
     * Set digestAuthentication value
     * @param string $digestAuthentication
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setDigestAuthentication($digestAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($digestAuthentication) && !is_string($digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestAuthentication, true), gettype($digestAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($digestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($digestAuthentication, true)), __LINE__);
        }
        $this->digestAuthentication = $digestAuthentication;
        return $this;
    }
    /**
     * Get noncePolicyTime value
     * @return string|null
     */
    public function getNoncePolicyTime()
    {
        return $this->noncePolicyTime;
    }
    /**
     * Set noncePolicyTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $noncePolicyTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setNoncePolicyTime($noncePolicyTime = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($noncePolicyTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($noncePolicyTime) ? implode(', ', $noncePolicyTime) : var_export($noncePolicyTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->noncePolicyTime = $noncePolicyTime;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509SubjectName, true), gettype($x509SubjectName)), __LINE__);
        }
        // validation for constraint: maxLength(4096)
        if (!is_null($x509SubjectName) && mb_strlen($x509SubjectName) > 4096) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4096', mb_strlen($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get incomingPort value
     * @return string|null
     */
    public function getIncomingPort()
    {
        return $this->incomingPort;
    }
    /**
     * Set incomingPort value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingPort
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setIncomingPort($incomingPort = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($incomingPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($incomingPort) ? implode(', ', $incomingPort) : var_export($incomingPort, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->incomingPort = $incomingPort;
        return $this;
    }
    /**
     * Get applLevelAuthentication value
     * @return string|null
     */
    public function getApplLevelAuthentication()
    {
        return $this->applLevelAuthentication;
    }
    /**
     * Set applLevelAuthentication value
     * @param string $applLevelAuthentication
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setApplLevelAuthentication($applLevelAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($applLevelAuthentication) && !is_string($applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applLevelAuthentication, true), gettype($applLevelAuthentication)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($applLevelAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($applLevelAuthentication, true)), __LINE__);
        }
        $this->applLevelAuthentication = $applLevelAuthentication;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = null)
    {
        // validation for constraint: string
        if (!is_null($acceptPresenceSubscription) && !is_string($acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptPresenceSubscription, true), gettype($acceptPresenceSubscription)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptPresenceSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptPresenceSubscription, true)), __LINE__);
        }
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = null)
    {
        // validation for constraint: string
        if (!is_null($acceptOutOfDialogRefer) && !is_string($acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptOutOfDialogRefer, true), gettype($acceptOutOfDialogRefer)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptOutOfDialogRefer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptOutOfDialogRefer, true)), __LINE__);
        }
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = null)
    {
        // validation for constraint: string
        if (!is_null($acceptUnsolicitedNotification) && !is_string($acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptUnsolicitedNotification, true), gettype($acceptUnsolicitedNotification)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptUnsolicitedNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptUnsolicitedNotification, true)), __LINE__);
        }
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setAllowReplaceHeader($allowReplaceHeader = null)
    {
        // validation for constraint: string
        if (!is_null($allowReplaceHeader) && !is_string($allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowReplaceHeader, true), gettype($allowReplaceHeader)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowReplaceHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowReplaceHeader, true)), __LINE__);
        }
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get transmitSecurityStatus value
     * @return string|null
     */
    public function getTransmitSecurityStatus()
    {
        return $this->transmitSecurityStatus;
    }
    /**
     * Set transmitSecurityStatus value
     * @param string $transmitSecurityStatus
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setTransmitSecurityStatus($transmitSecurityStatus = null)
    {
        // validation for constraint: string
        if (!is_null($transmitSecurityStatus) && !is_string($transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmitSecurityStatus, true), gettype($transmitSecurityStatus)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($transmitSecurityStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($transmitSecurityStatus, true)), __LINE__);
        }
        $this->transmitSecurityStatus = $transmitSecurityStatus;
        return $this;
    }
    /**
     * Get sipV150OutboundSdpOfferFiltering value
     * @return string|null
     */
    public function getSipV150OutboundSdpOfferFiltering()
    {
        return $this->sipV150OutboundSdpOfferFiltering;
    }
    /**
     * Set sipV150OutboundSdpOfferFiltering value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XV150SDPFilter::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XV150SDPFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipV150OutboundSdpOfferFiltering
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XV150SDPFilter::valueIsValid($sipV150OutboundSdpOfferFiltering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XV150SDPFilter', is_array($sipV150OutboundSdpOfferFiltering) ? implode(', ', $sipV150OutboundSdpOfferFiltering) : var_export($sipV150OutboundSdpOfferFiltering, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XV150SDPFilter::getValidValues())), __LINE__);
        }
        $this->sipV150OutboundSdpOfferFiltering = $sipV150OutboundSdpOfferFiltering;
        return $this;
    }
    /**
     * Get allowChargingHeader value
     * @return string|null
     */
    public function getAllowChargingHeader()
    {
        return $this->allowChargingHeader;
    }
    /**
     * Set allowChargingHeader value
     * @param string $allowChargingHeader
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setAllowChargingHeader($allowChargingHeader = null)
    {
        // validation for constraint: string
        if (!is_null($allowChargingHeader) && !is_string($allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowChargingHeader, true), gettype($allowChargingHeader)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowChargingHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowChargingHeader, true)), __LINE__);
        }
        $this->allowChargingHeader = $allowChargingHeader;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \Losc\CucmBundle\Model\Webservice\StructType\LSipTrunkSecurityProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
